/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.instance.internal.input;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import javax.inject.Inject;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.descriptor.DefaultFilterStreamBeanDescriptor;
import org.xwiki.filter.descriptor.FilterStreamDescriptor;
import org.xwiki.filter.instance.input.AbstractEntityEventGenerator;
import org.xwiki.filter.instance.input.BeanEntityEventGenerator;
import org.xwiki.properties.BeanManager;

public abstract class AbstractBeanEntityEventGenerator<E, F, P>
extends AbstractEntityEventGenerator<E, F>
implements BeanEntityEventGenerator<E, P> {
    @Inject
    private BeanManager beanManager;
    private String name;
    private String description;
    private Class<P> propertiesType;

    @Override
    public void initialize() throws InitializationException {
        super.initialize();
        ParameterizedType genericType = (ParameterizedType)ReflectionUtils.resolveType(AbstractBeanEntityEventGenerator.class, this.getClass());
        this.propertiesType = ReflectionUtils.getTypeClass((Type)genericType.getActualTypeArguments()[2]);
        DefaultFilterStreamBeanDescriptor descriptor = new DefaultFilterStreamBeanDescriptor(this.getName(), this.getDescription(), this.beanManager.getBeanDescriptor(!this.propertiesType.isInterface() ? this.propertiesType : Object.class));
        this.setDescriptor((FilterStreamDescriptor)descriptor);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    protected void write(E entity, Object filter, F internalFilter, Map<String, Object> properties) throws FilterException {
        Map<String, Object> propertiesBean;
        if (this.propertiesType.isInstance(properties)) {
            propertiesBean = properties;
        } else {
            try {
                propertiesBean = this.propertiesType.newInstance();
                this.beanManager.populate(propertiesBean, properties);
            }
            catch (Exception e) {
                throw new FilterException("Failed to convert properties to Java bean", (Throwable)e);
            }
        }
        this.write(entity, filter, internalFilter, (P)propertiesBean);
    }

    @Override
    public void write(E entity, Object filter, P properties) throws FilterException {
        Object internalFilter = this.filterDescriptorManager.createFilterProxy(filter, new Class[]{this.filterType});
        this.write(entity, filter, internalFilter, properties);
    }

    protected abstract void write(E var1, Object var2, F var3, P var4) throws FilterException;
}

