/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.feed.internal;

import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.SyndFeedInput;
import com.rometools.rome.io.XmlReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;

public class XWikiFeedFetcher {
    private String userAgent = "XWikiFeedFetcher/1.0";

    public SyndFeed retrieveFeed(URL feedUrl) throws IOException, FeedException {
        return this.retrieveFeed(feedUrl, 0);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public SyndFeed retrieveFeed(URL feedUrl, int timeout) throws IOException {
        if (feedUrl == null) {
            throw new IllegalArgumentException("null is not a valid URL");
        }
        try (CloseableHttpClient httpclient = HttpClients.createSystem();){
            HttpGet httpGet = new HttpGet(feedUrl.toString());
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout((long)timeout, TimeUnit.SECONDS).setResponseTimeout((long)timeout, TimeUnit.SECONDS).build();
            httpGet.setConfig(requestConfig);
            httpGet.setHeader("User-Agent", (Object)this.getUserAgent());
            SyndFeed syndFeed = (SyndFeed)httpclient.execute((ClassicHttpRequest)httpGet, response -> {
                SyndFeed syndFeed;
                block9: {
                    if (response.getCode() != 200) {
                        throw new IOException("Failed to fetch feed: %d %s".formatted(response.getCode(), response.getReasonPhrase()));
                    }
                    InputStream content = response.getEntity().getContent();
                    try {
                        SyndFeedInput input = new SyndFeedInput();
                        syndFeed = input.build((Reader)new XmlReader(content));
                        if (content == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (content != null) {
                                try {
                                    content.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (FeedException e) {
                            throw new IOException("Failed to parse feed", e);
                        }
                    }
                    content.close();
                }
                return syndFeed;
            });
            return syndFeed;
        }
    }
}

