/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.script;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.Extension;
import org.xwiki.extension.RemoteExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.index.ExtensionIndex;
import org.xwiki.extension.index.IndexedExtension;
import org.xwiki.extension.index.IndexedExtensionQuery;
import org.xwiki.extension.rating.RatingExtension;
import org.xwiki.extension.script.AbstractExtensionScriptService;
import org.xwiki.extension.wrap.WrappingIndexedExtension;
import org.xwiki.extension.wrap.WrappingRatingExtension;
import org.xwiki.script.service.ScriptService;
import org.xwiki.script.service.ScriptServiceManager;
import org.xwiki.stability.Unstable;

@Component
@Named(value="extension.index")
@Singleton
public class ExtensionIndexScriptService
extends AbstractExtensionScriptService {
    public static final String ID = "index";
    @Inject
    private ExtensionIndex index;
    @Inject
    private ScriptServiceManager scriptServiceManager;

    public ExtensionIndex getRepository() {
        return (ExtensionIndex)this.safe(this.index);
    }

    public IndexedExtensionQuery newQuery(String query) {
        return new IndexedExtensionQuery(query);
    }

    @Unstable
    public IndexedExtension getIndexedExtension(Extension extension) {
        if (extension instanceof IndexedExtension) {
            IndexedExtension indexedExtension = (IndexedExtension)extension;
            return indexedExtension;
        }
        try {
            return this.index.resolve(extension.getId());
        }
        catch (ResolveException e) {
            return new WrappingIndexedExtension(extension);
        }
    }

    @Unstable
    public RatingExtension getRatingExtension(Extension extension) {
        if (extension instanceof RatingExtension) {
            RatingExtension ratingExtension = (RatingExtension)extension;
            return ratingExtension;
        }
        try {
            return this.index.resolve(extension.getId());
        }
        catch (ResolveException e) {
            return new WrappingRatingExtension(extension);
        }
    }

    @Unstable
    public RemoteExtension getRemoteExtension(Extension extension) {
        if (extension instanceof RemoteExtension) {
            RemoteExtension remoteExtension = (RemoteExtension)extension;
            return remoteExtension;
        }
        try {
            return this.index.resolve(extension.getId());
        }
        catch (ResolveException e) {
            return new WrappingRatingExtension(extension);
        }
    }

    public <S extends ScriptService> S get(String serviceName) {
        return (S)this.scriptServiceManager.get("extension.index." + serviceName);
    }
}

