/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.script;

import com.xpn.xwiki.XWikiContext;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.PredicateUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.job.history.ExtensionJobHistory;
import org.xwiki.extension.job.history.ExtensionJobHistoryRecord;
import org.xwiki.extension.job.history.ExtensionJobHistorySerializer;
import org.xwiki.extension.job.history.ReplayJobStatus;
import org.xwiki.extension.job.history.ReplayRequest;
import org.xwiki.extension.script.AbstractExtensionScriptService;
import org.xwiki.job.AbstractRequest;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.Request;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="extension.history")
@Singleton
public class ExtensionHistoryScriptService
extends AbstractExtensionScriptService {
    public static final String ID = "history";
    @Inject
    private ExtensionJobHistory history;
    @Inject
    private ExtensionJobHistorySerializer serializer;

    public ExtensionHistoryFilter getRecords() {
        return new ExtensionHistoryFilter();
    }

    public String serialize(ExtensionJobHistoryRecord record) {
        this.setError(null);
        try {
            return this.serializer.serialize(record);
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public List<ExtensionJobHistoryRecord> deserialize(String serializedHistoryRecords) {
        this.setError(null);
        try {
            return this.serializer.deserialize(serializedHistoryRecords);
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public List<ExtensionJobHistoryRecord> read(InputStream inputStream) {
        this.setError(null);
        try {
            return this.serializer.read((Reader)new InputStreamReader(inputStream));
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public Job replay(List<ExtensionJobHistoryRecord> records) {
        this.setError(null);
        ReplayRequest request = this.createReplayRequest(this.createReplayPlan(records, true, null));
        try {
            return this.jobExecutor.execute("replay", (Request)request);
        }
        catch (JobException e) {
            this.setError((Exception)((Object)e));
            return null;
        }
    }

    public List<ExtensionJobHistoryRecord> createReplayPlan(List<ExtensionJobHistoryRecord> records, boolean preserveUsers, Collection<String> namespaces) {
        String currentWiki = ((XWikiContext)this.xcontextProvider.get()).getWikiId();
        if (!this.authorization.hasAccess(Right.ADMIN, (EntityReference)new WikiReference(currentWiki))) {
            return Collections.emptyList();
        }
        if (!this.authorization.hasAccess(Right.PROGRAM)) {
            return this.createReplayPlanInternal(records, false, Arrays.asList("wiki:" + currentWiki));
        }
        return this.createReplayPlanInternal(records, preserveUsers, namespaces);
    }

    public ReplayJobStatus getReplayJobStatus(String id) {
        return (ReplayJobStatus)this.getJobStatus(this.getReplayJobId(id));
    }

    private List<ExtensionJobHistoryRecord> createReplayPlanInternal(List<ExtensionJobHistoryRecord> records, boolean preserveUsers, Collection<String> namespaces) {
        for (ExtensionJobHistoryRecord record : records) {
            if (!preserveUsers) {
                this.setRightsProperties((AbstractRequest)record.getRequest());
            }
            if (!record.getRequest().hasNamespaces() || namespaces == null || namespaces.size() <= 0) continue;
            ((AbstractRequest)record.getRequest()).setProperty("namespaces", namespaces);
        }
        return records;
    }

    private ReplayRequest createReplayRequest(List<ExtensionJobHistoryRecord> records) {
        ReplayRequest request = new ReplayRequest();
        String suffix = new Date().getTime() + "-" + ThreadLocalRandom.current().nextInt(100, 1000);
        request.setId(this.getReplayJobId(suffix));
        request.setInteractive(true);
        request.setRecords(records);
        this.contextualize((AbstractRequest)request);
        this.setRightsProperties(request);
        return request;
    }

    private List<String> getReplayJobId(String suffix) {
        return Arrays.asList("extension", ID, suffix);
    }

    public class ExtensionHistoryFilter {
        private final List<Predicate<ExtensionJobHistoryRecord>> constraints = new ArrayList<Predicate<ExtensionJobHistoryRecord>>();

        public ExtensionHistoryFilter ofType(final List<String> jobTypes) {
            this.constraints.add(new Predicate<ExtensionJobHistoryRecord>(){

                public boolean evaluate(ExtensionJobHistoryRecord record) {
                    return jobTypes.contains(record.getJobType());
                }
            });
            return this;
        }

        public ExtensionHistoryFilter fromThisWiki() {
            final String currentWikiNamespace = "wiki:" + ((XWikiContext)ExtensionHistoryScriptService.this.xcontextProvider.get()).getWikiId();
            this.constraints.add(new Predicate<ExtensionJobHistoryRecord>(){

                public boolean evaluate(ExtensionJobHistoryRecord record) {
                    return !record.getRequest().hasNamespaces() || record.getRequest().getNamespaces().contains(currentWikiNamespace);
                }
            });
            return this;
        }

        public List<ExtensionJobHistoryRecord> list(String offsetRecordId, int limit) {
            return ExtensionHistoryScriptService.this.history.getRecords(PredicateUtils.allPredicate(this.constraints), offsetRecordId, limit);
        }
    }
}

