/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.index.internal.listener;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.index.internal.ExtensionIndexSolrUtil;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.ApplicationStartedEvent;
import org.xwiki.observation.event.Event;
import org.xwiki.search.solr.Solr;
import org.xwiki.search.solr.SolrException;
import org.xwiki.search.solr.SolrUtils;

@Component
@Singleton
@Named(value="ExtensionIndexCleanupListener")
public class ExtensionIndexCleanupListener
implements EventListener {
    public static final String ID = "ExtensionIndexCleanupListener";
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private InstalledExtensionRepository installedExtensionRepository;
    @Inject
    private Solr solr;
    @Inject
    private SolrUtils solrUtils;
    @Inject
    private ExtensionIndexSolrUtil extensionIndexSolrUtil;
    @Inject
    private Logger logger;

    public String getName() {
        return ID;
    }

    public List<Event> getEvents() {
        return List.of(new ApplicationStartedEvent());
    }

    public void onEvent(Event event, Object source, Object data) {
        Thread thread = new Thread(this::proceed);
        thread.setName(ID);
        thread.setPriority(thread.getPriority() - 2);
        thread.start();
    }

    void proceed() {
        try {
            SolrClient client = this.solr.getClient("extension_index");
            SolrQuery solrQuery = new SolrQuery().setFields(new String[]{"id", "is_core_extension", "installedNamespaces"});
            int batchSize = 1000;
            QueryResponse search = client.query((SolrParams)solrQuery.setRows(Integer.valueOf(batchSize)).setStart(Integer.valueOf(0)));
            while (!search.getResults().isEmpty()) {
                for (SolrDocument doc : search.getResults()) {
                    String id;
                    ExtensionId extensionId;
                    if (!this.cleanCoreExtension(doc, extensionId = this.extensionIndexSolrUtil.fromSolrId(id = this.solrUtils.getId(doc))) && !this.cleanInstalledExtension(doc, extensionId)) continue;
                    client.deleteById(id);
                    this.logger.info("Remove outdated extension [{}] from the solr index", (Object)id);
                }
                search = client.query((SolrParams)solrQuery.setStart(Integer.valueOf(solrQuery.getStart() + batchSize)));
            }
            client.commit();
        }
        catch (SolrException e) {
            this.logger.error("Failed to get a solr client for the [{}] index.", (Object)"extension_index", (Object)e);
        }
        catch (IOException | SolrServerException e) {
            this.logger.error("Failed to perform a solr query.", e);
        }
    }

    private boolean cleanCoreExtension(SolrDocument doc, ExtensionId extensionId) {
        boolean isCoreExtension = Objects.equals(doc.getFieldValue("is_core_extension"), true);
        return isCoreExtension && !this.coreExtensionRepository.exists(extensionId);
    }

    private boolean cleanInstalledExtension(SolrDocument doc, ExtensionId extensionId) {
        boolean isInstalled = CollectionUtils.isNotEmpty((Collection)doc.getFieldValues("installedNamespaces"));
        return isInstalled && !this.installedExtensionRepository.exists(extensionId);
    }
}

