/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.index.internal.job;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.xwiki.component.namespace.Namespace;
import org.xwiki.job.AbstractRequest;

public class ExtensionIndexRequest
extends AbstractRequest {
    public static final List<String> JOB_ID = Arrays.asList("extension", "index");
    private static final long serialVersionUID = 1L;
    private boolean localExtensionsEnabled;
    private final boolean remoteExtensionsEnabled;
    private List<Namespace> namespaces;

    public ExtensionIndexRequest(boolean localExtensionsEnabled, boolean remoteExtensionsEnabled, Collection<Namespace> namespaces) {
        this.setId(JOB_ID);
        this.setVerbose(false);
        this.setStatusLogIsolated(false);
        this.localExtensionsEnabled = localExtensionsEnabled;
        this.remoteExtensionsEnabled = remoteExtensionsEnabled;
        List<Object> list = this.namespaces = namespaces != null ? Collections.unmodifiableList(new ArrayList<Namespace>(namespaces)) : Collections.emptyList();
        if (this.namespaces.size() == 1) {
            this.setId(ExtensionIndexRequest.getId(this.namespaces.get(0)));
        }
    }

    public ExtensionIndexRequest(ExtensionIndexRequest request) {
        this(request.isLocalExtensionsEnabled(), request.isRemoteExtensionsEnabled(), request.getNamespaces());
    }

    public static List<String> getId(Namespace namespace) {
        String namespaceString;
        ArrayList<String> id = new ArrayList<String>(JOB_ID);
        if (namespace != null && (namespaceString = namespace.serialize()) != null) {
            id.add(namespace.serialize());
        }
        return id;
    }

    public void setLocalExtensionsEnabled(boolean localExtensionsEnabled) {
        this.localExtensionsEnabled = localExtensionsEnabled;
    }

    public void addNamespace(Namespace namespace) {
        ArrayList<Namespace> list = new ArrayList<Namespace>();
        list.addAll(this.namespaces);
        list.add(namespace);
        this.namespaces = Collections.unmodifiableList(list);
    }

    public void removeNamespace(Namespace namespace) {
        ArrayList<Namespace> list = new ArrayList<Namespace>();
        list.addAll(this.namespaces);
        list.remove(namespace);
        this.namespaces = Collections.unmodifiableList(list);
    }

    public boolean isLocalExtensionsEnabled() {
        return this.localExtensionsEnabled;
    }

    public boolean isRemoteExtensionsEnabled() {
        return this.remoteExtensionsEnabled;
    }

    public List<Namespace> getNamespaces() {
        return this.namespaces;
    }
}

