/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.index.internal.job;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.namespace.Namespace;
import org.xwiki.component.phase.Disposable;
import org.xwiki.extension.ExtensionManagerConfiguration;
import org.xwiki.extension.index.ExtensionIndexStatus;
import org.xwiki.extension.index.internal.job.ExtensionIndexRequest;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.JobStatusStore;
import org.xwiki.job.Request;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.model.namespace.WikiNamespace;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component(roles={ExtensionIndexJobScheduler.class})
@Singleton
public class ExtensionIndexJobScheduler
implements Disposable {
    @Inject
    private JobExecutor jobs;
    @Inject
    private JobStatusStore jobStore;
    @Inject
    private ExtensionManagerConfiguration configuration;
    @Inject
    private WikiDescriptorManager wikis;
    @Inject
    private Logger logger;
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final ExtensionIndexRequest scheduledRequest = new ExtensionIndexRequest(true, true, Arrays.asList(Namespace.ROOT));
    private ExtensionIndexRequest currentRequest;
    private boolean extensionAdded;
    private volatile boolean disposed;

    public void start() {
        this.scheduledRequest.addNamespace((Namespace)new WikiNamespace(this.wikis.getMainWikiId()));
        this.executeFirstJob();
    }

    public void initialize(Namespace namespace) {
        this.scheduledRequest.addNamespace(namespace);
        if (this.extensionAdded) {
            this.executeJob(new ExtensionIndexRequest(false, false, Arrays.asList(namespace)));
        }
    }

    public ExtensionIndexStatus index(Namespace namespace) throws JobException {
        Job job = this.currentRequest != null && this.currentRequest.getNamespaces().contains(namespace) ? this.jobs.getJob(ExtensionIndexRequest.getId(namespace)) : null;
        if (job == null || job.getStatus().getState() == JobStatus.State.FINISHED) {
            ExtensionIndexRequest request = new ExtensionIndexRequest(false, true, Arrays.asList(namespace));
            if (namespace.getType().equals("wiki") && this.wikis.isMainWiki(namespace.getValue())) {
                request.addNamespace(Namespace.ROOT);
            }
            job = this.jobs.execute("extension.index", (Request)request);
        }
        return (ExtensionIndexStatus)job.getStatus();
    }

    public ExtensionIndexStatus getStatus(Namespace namespace) {
        ExtensionIndexStatus scheduledStatus;
        List<String> id = ExtensionIndexRequest.getId(namespace);
        Job job = this.jobs.getJob(id);
        if (job == null && this.scheduledRequest.getNamespaces().contains(namespace)) {
            job = this.jobs.getJob(this.scheduledRequest.getId());
        }
        if (job != null) {
            return (ExtensionIndexStatus)job.getStatus();
        }
        ExtensionIndexStatus namespaceStatus = (ExtensionIndexStatus)this.jobStore.getJobStatus(id);
        ExtensionIndexStatus extensionIndexStatus = scheduledStatus = !id.equals(this.scheduledRequest.getId()) ? (ExtensionIndexStatus)this.jobStore.getJobStatus(this.scheduledRequest.getId()) : null;
        if (this.hasAStartDate(namespaceStatus) && (scheduledStatus == null || namespaceStatus.getStartDate().after(scheduledStatus.getStartDate()) || !((ExtensionIndexRequest)scheduledStatus.getRequest()).getNamespaces().contains(namespace))) {
            return namespaceStatus;
        }
        return scheduledStatus;
    }

    private boolean hasAStartDate(ExtensionIndexStatus status) {
        return status != null && status.getStartDate() != null;
    }

    public void add(Namespace namespace) {
        this.scheduledRequest.addNamespace(namespace);
        this.executeJob(new ExtensionIndexRequest(false, false, Arrays.asList(namespace)));
    }

    public void remove(Namespace namespace) {
        this.scheduledRequest.removeNamespace(namespace);
    }

    private void executeFirstJob() {
        this.scheduler.execute(this::runFirstJob);
    }

    private void executeJob(ExtensionIndexRequest request) {
        this.scheduler.execute(() -> this.runJob(request));
    }

    private void runFirstJob() {
        this.runScheduledJob();
        if (!this.disposed) {
            this.scheduledRequest.setLocalExtensionsEnabled(false);
            this.scheduler.scheduleWithFixedDelay(this::runScheduledJob, this.configuration.getIndexInterval(), this.configuration.getIndexInterval(), TimeUnit.SECONDS);
        }
    }

    private void runScheduledJob() {
        Job job;
        if (!this.disposed && (job = this.runJob(this.scheduledRequest)) != null) {
            ExtensionIndexStatus status = (ExtensionIndexStatus)job.getStatus();
            this.extensionAdded |= status.isExtensionAdded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Job runJob(ExtensionIndexRequest request) {
        this.currentRequest = request;
        try {
            Job job = this.jobs.execute("extension.index", (Request)request);
            job.join();
            Job job2 = job;
            return job2;
        }
        catch (Exception e) {
            if (!this.disposed) {
                this.logger.error("Failed to execute job", (Throwable)e);
            }
        }
        finally {
            this.currentRequest = null;
        }
        return null;
    }

    public void dispose() throws ComponentLifecycleException {
        this.disposed = true;
        this.scheduler.shutdownNow();
    }
}

