/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.index.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.solr.common.SolrInputDocument;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.namespace.Namespace;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.internal.ExtensionFactory;
import org.xwiki.extension.internal.converter.ExtensionIdConverter;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.search.solr.SolrUtils;

@Component(roles={ExtensionIndexSolrUtil.class})
@Singleton
public class ExtensionIndexSolrUtil {
    private static final String ROOT_NAMESPACE = "{root}";
    @Inject
    private InstalledExtensionRepository installedExtensions;
    @Inject
    private SolrUtils utils;
    @Inject
    private ExtensionFactory factory;

    public void updateInstalledState(ExtensionId extensionId, SolrInputDocument document) {
        InstalledExtension installedExtension = this.installedExtensions.getInstalledExtension(extensionId);
        if (installedExtension != null) {
            List<String> installedNamespaces = installedExtension.getNamespaces() == null ? Collections.singletonList(this.toStoredNamespace((String)null)) : installedExtension.getNamespaces().stream().map(this::toStoredNamespace).collect(Collectors.toList());
            this.utils.setAtomic("set", "installedNamespaces", installedNamespaces, document);
            this.utils.set("s_incompatibleNamespaces", installedNamespaces, document);
        } else {
            this.utils.setAtomic("set", "installedNamespaces", null, document);
        }
    }

    public String toStoredNamespace(Namespace namespace) {
        return namespace != null ? this.toStoredNamespace(namespace.toString()) : ROOT_NAMESPACE;
    }

    public String toStoredNamespace(String namespace) {
        if (namespace == null) {
            return ROOT_NAMESPACE;
        }
        return namespace;
    }

    public List<String> fromStoredNamespaces(Collection<String> solrNamespaces) {
        if (solrNamespaces == null) {
            return List.of();
        }
        return solrNamespaces.stream().map(this::fromStoredNamespace).collect(Collectors.toList());
    }

    public ExtensionId fromSolrId(String solrId) {
        return ExtensionIdConverter.toExtensionId((Object)solrId, null, (ExtensionFactory)this.factory);
    }

    public String toSolrId(ExtensionId extensionId) {
        return ExtensionIdConverter.toString((ExtensionId)extensionId);
    }

    private String fromStoredNamespace(String storedNamespace) {
        if (storedNamespace == null || storedNamespace.equals(ROOT_NAMESPACE)) {
            return null;
        }
        return storedNamespace;
    }
}

