/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.index.internal;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.solr.client.solrj.SolrServerException;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.DefaultExtensionComponent;
import org.xwiki.search.solr.AbstractSolrCoreInitializer;
import org.xwiki.search.solr.SolrException;

@Component
@Named(value="extension_index")
@Singleton
public class ExtensionIndexSolrCoreInitializer
extends AbstractSolrCoreInitializer {
    public static final String NAME = "extension_index";
    public static final String INDEX_SUFFIX = "_index";
    public static final String SOLR_FIELD_EXTENSIONFEATURES_INDEX = "extensionfeatures_index";
    public static final String SOLR_FIELD_AUTHORS_INDEX = "authors_index";
    public static final String SOLR_FIELD_COMPONENTS_INDEX = "components_index";
    public static final String SOLR_FIELD_EXTENSIONID = "s_extensionId";
    public static final String SOLR_FIELD_COMPATIBLE_NAMESPACES = "s_compatibleNamespaces";
    public static final String SOLR_FIELD_INCOMPATIBLE_NAMESPACES = "s_incompatibleNamespaces";
    public static final String SOLR_FIELD_LAST = "s_last";
    public static final String SOLR_FIELD_INDEX_DATE = "s_indexDate";
    public static final String SECURITY_MAX_CVSS = "security_maxCVSS";
    public static final String SECURITY_CVE_ID = "security_cveID";
    public static final String SECURITY_CVE_LINK = "security_cveLink";
    public static final String SECURITY_CVE_CVSS = "security_cveCVSS";
    public static final String SECURITY_CVE_COUNT = "security_cveCount";
    public static final String SECURITY_FIX_VERSION = "security_fixVersion";
    public static final String SECURITY_ADVICE = "security_advice";
    public static final String IS_CORE_EXTENSION = "is_core_extension";
    public static final String IS_REVIEWED_SAFE = "security_is_reviewed_safe";
    public static final String IS_SAFE_EXPLANATIONS = "security_is_safe_explanations";
    private static final Pattern COMPONENT_SPECIAL_CHARS = Pattern.compile("[<>,]+");

    protected long getVersion() {
        return 160700000L;
    }

    public boolean isCache() {
        return true;
    }

    protected void createSchema() throws SolrException {
        this.setStringField(SOLR_FIELD_EXTENSIONID, false, false, new Object[0]);
        this.setStringField("version", false, false, new Object[0]);
        this.setStringField("type", false, false, new Object[0]);
        this.setStringField("repository", false, false, new Object[0]);
        this.setStringField("allowednamespaces", true, false, new Object[0]);
        this.setStringField("category", false, false, new Object[0]);
        this.setTextGeneralField("name", false, false, new Object[0]);
        this.setTextGeneralField("summary", false, false, new Object[0]);
        this.setTextGeneralField("website", false, false, new Object[0]);
        this.setBooleanField("recommended", false, false, new Object[0]);
        this.setPIntField("nbvotes", false, false, new Object[0]);
        this.setPFloatField("averagevote", false, false, new Object[0]);
        this.setStringField("authors", true, false, new Object[0]);
        this.setTextGeneralField(SOLR_FIELD_AUTHORS_INDEX, true, false, new Object[]{"stored", false});
        this.setStringField("extensionfeatures", true, false, new Object[0]);
        this.setTextGeneralField(SOLR_FIELD_EXTENSIONFEATURES_INDEX, true, false, new Object[]{"stored", false});
        this.setPDateField(SOLR_FIELD_INDEX_DATE, false, false, new Object[0]);
        this.setBooleanField(SOLR_FIELD_LAST, false, false, new Object[0]);
        this.setStringField(SOLR_FIELD_COMPATIBLE_NAMESPACES, true, false, new Object[0]);
        this.setStringField(SOLR_FIELD_INCOMPATIBLE_NAMESPACES, true, false, new Object[0]);
        this.migrateSchema(120900000L);
    }

    protected void migrateSchema(long cversion) throws SolrException {
        if (cversion < 130300000L) {
            this.setStringField("components", true, false, new Object[0]);
            this.setTextGeneralField(SOLR_FIELD_COMPONENTS_INDEX, true, false, new Object[]{"stored", false});
            this.addCopyField("components", new String[]{SOLR_FIELD_COMPONENTS_INDEX});
            this.setStringField(ExtensionIndexSolrCoreInitializer.toComponentFieldName("*"), true, true, new Object[0]);
        }
        if (cversion < 140000000L) {
            this.setStringField("installedNamespaces", true, false, new Object[0]);
        }
        if (cversion < 150500000L) {
            this.setPDoubleField(SECURITY_MAX_CVSS, false, false, new Object[0]);
            this.setStringField(SECURITY_CVE_ID, true, false, new Object[0]);
            this.setStringField(SECURITY_CVE_LINK, true, false, new Object[0]);
            this.setPDoubleField(SECURITY_CVE_CVSS, true, false, new Object[0]);
            this.setPIntField(SECURITY_CVE_COUNT, false, false, new Object[0]);
            this.setStringField(SECURITY_FIX_VERSION, false, false, new Object[0]);
            this.setStringField(SECURITY_ADVICE, false, false, new Object[0]);
        }
        if (cversion < 150600000L) {
            this.setBooleanField(IS_REVIEWED_SAFE, true, false, new Object[0]);
            this.setStringField(IS_SAFE_EXPLANATIONS, true, false, new Object[0]);
        }
        if (cversion < 150900000L) {
            this.setBooleanField(IS_CORE_EXTENSION, false, false, new Object[0]);
            if (cversion >= 150600000L) {
                try {
                    this.core.getClient().deleteByQuery("is_installed:[* TO *] OR is_from_environment:[* TO *]");
                }
                catch (IOException | SolrServerException e) {
                    throw new SolrException("Failed to cleanup is_installed field", (Exception)e);
                }
                this.deleteField("is_installed", false);
                this.deleteField("is_from_environment", false);
            }
        }
        if (cversion < 160700000L) {
            this.setStringField("supportplans", true, false, new Object[0]);
        }
    }

    public static String toComponentFieldName(String componentType) {
        String cannonicalType = DefaultExtensionComponent.toCanonicalComponentType((String)componentType);
        cannonicalType = COMPONENT_SPECIAL_CHARS.matcher(cannonicalType).replaceAll("_");
        return "components__" + cannonicalType;
    }
}

