/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal.job.step;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.namespace.Namespace;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.distribution.internal.DistributionManager;
import org.xwiki.extension.distribution.internal.job.step.AbstractExtensionDistributionStep;
import org.xwiki.extension.distribution.internal.job.step.DistributionStep;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Named(value="extension.defaultui.wikis")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class WikisDefaultUIDistributionStep
extends AbstractExtensionDistributionStep {
    public static final String ID = "extension.defaultui.wikis";
    @Inject
    private transient InstalledExtensionRepository installedRepository;
    @Inject
    protected transient DistributionManager distributionManager;
    @Inject
    private transient Logger logger;

    public WikisDefaultUIDistributionStep() {
        super(ID);
    }

    @Override
    public void prepare() {
        if (this.getState() == null) {
            Collection wikiIds;
            this.setState(DistributionStep.State.COMPLETED);
            WikiDescriptorManager wikiDescriptorManager = (WikiDescriptorManager)this.wikiDescriptorManagerProvider.get();
            try {
                wikiIds = wikiDescriptorManager.getAllIds();
            }
            catch (WikiManagerException e) {
                this.logger.error("Failed to get the list of wikis", (Throwable)e);
                this.setState(null);
                return;
            }
            ExtensionId wikiExtensionUI = this.distributionManager.getWikiUIExtensionId();
            if (wikiExtensionUI != null) {
                for (String wikiId : wikiIds) {
                    if (wikiDescriptorManager.getMainWikiId().equals(wikiId)) continue;
                    String namespace = "wiki:" + wikiId;
                    InstalledExtension installedExtension = this.installedRepository.getInstalledExtension(wikiExtensionUI.getId(), namespace);
                    if (installedExtension != null && installedExtension.getId().getVersion().equals(wikiExtensionUI.getVersion())) continue;
                    this.setState(null);
                    return;
                }
            }
        }
    }

    @Override
    public void executeNonInteractive() throws Exception {
        Collection wikiIds;
        WikiDescriptorManager wikiDescriptorManager = (WikiDescriptorManager)this.wikiDescriptorManagerProvider.get();
        try {
            wikiIds = wikiDescriptorManager.getAllIds();
        }
        catch (WikiManagerException e) {
            this.logger.error("Failed to get the list of wikis", (Throwable)e);
            this.setState(null);
            return;
        }
        ExtensionId wikiExtensionUI = this.distributionManager.getWikiUIExtensionId();
        for (String wikiId : wikiIds) {
            InstalledExtension installedExtension;
            if (wikiDescriptorManager.getMainWikiId().equals(wikiId)) continue;
            String namespace = new Namespace("wiki", wikiId).toString();
            if (wikiExtensionUI == null || (installedExtension = this.installedRepository.getInstalledExtension(wikiExtensionUI.getId(), namespace)) != null && installedExtension.getId().getVersion().equals(wikiExtensionUI.getVersion())) continue;
            this.install(wikiExtensionUI, namespace, false);
        }
        this.setState(DistributionStep.State.COMPLETED);
    }
}

