/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal.job.step;

import javax.inject.Inject;
import javax.inject.Provider;
import org.xwiki.component.namespace.Namespace;
import org.xwiki.extension.distribution.internal.job.DistributionJob;
import org.xwiki.extension.distribution.internal.job.DistributionJobStatus;
import org.xwiki.extension.distribution.internal.job.step.DistributionStep;
import org.xwiki.job.annotation.Serializable;
import org.xwiki.rendering.block.Block;
import org.xwiki.template.TemplateManager;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Serializable
public abstract class AbstractDistributionStep
implements DistributionStep {
    @Inject
    protected transient TemplateManager renderer;
    @Inject
    protected transient Provider<WikiDescriptorManager> wikiDescriptorManagerProvider;
    private final String stepId;
    protected DistributionJob distributionJob;
    private DistributionStep.State state;

    public AbstractDistributionStep(String stepId) {
        this.stepId = stepId;
    }

    @Override
    public void initialize(DistributionJob distributionJob) {
        DistributionStep previousStep;
        this.distributionJob = distributionJob;
        DistributionJobStatus previousStatus = this.distributionJob.getPreviousStatus();
        if (previousStatus != null && previousStatus.getDistributionExtension().equals((Object)this.distributionJob.getStatus().getDistributionExtension()) && (previousStep = previousStatus.getStep(this.getId())) != null) {
            this.setState(previousStep.getState());
        }
    }

    @Override
    public String getId() {
        return this.stepId;
    }

    @Override
    public DistributionStep.State getState() {
        return this.state;
    }

    @Override
    public void setState(DistributionStep.State stepState) {
        this.state = stepState;
    }

    protected String getWiki() {
        return this.distributionJob.getRequest().getWiki();
    }

    protected boolean isMainWiki() {
        return ((WikiDescriptorManager)this.wikiDescriptorManagerProvider.get()).getMainWikiId().equals(this.getWiki());
    }

    protected Namespace getNamespace() {
        String wiki = this.getWiki();
        return wiki == null ? null : new Namespace("wiki", this.getWiki());
    }

    protected String getTemplate() {
        return "distribution/" + this.getId() + ".wiki";
    }

    protected boolean isInteractive() {
        return this.distributionJob.getRequest().isInteractive();
    }

    @Override
    public Block executeInteractive() {
        return this.renderer.executeNoException(this.getTemplate());
    }

    @Override
    public void executeNonInteractive() throws Exception {
        this.setState(DistributionStep.State.COMPLETED);
    }
}

