/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal.job;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Condition;
import javax.inject.Inject;
import javax.inject.Provider;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.extension.distribution.internal.DistributionConfiguration;
import org.xwiki.extension.distribution.internal.DistributionManager;
import org.xwiki.extension.distribution.internal.job.DistributionJob;
import org.xwiki.extension.distribution.internal.job.DistributionJobStatus;
import org.xwiki.extension.distribution.internal.job.DistributionQuestion;
import org.xwiki.extension.distribution.internal.job.DistributionRequest;
import org.xwiki.extension.distribution.internal.job.step.DistributionStep;
import org.xwiki.extension.distribution.internal.job.step.ReportDistributionStep;
import org.xwiki.extension.distribution.internal.job.step.WelcomeDistributionStep;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

public abstract class AbstractDistributionJob<R extends DistributionRequest>
extends AbstractJob<R, DistributionJobStatus>
implements DistributionJob {
    @Inject
    protected DistributionManager distributionManager;
    @Inject
    protected Provider<WikiDescriptorManager> wikiDescriptorManagerProvider;
    @Inject
    protected DistributionConfiguration distributionConfiguration;
    @Inject
    private ExecutionContextManager executionContextManager;
    protected final Condition readyCondition;

    public AbstractDistributionJob() {
        this.readyCondition = this.lock.newCondition();
    }

    public String getType() {
        return "distribution";
    }

    protected String getWiki() {
        return ((DistributionRequest)this.getRequest()).getWiki();
    }

    protected boolean isMainWiki() {
        return ((WikiDescriptorManager)this.wikiDescriptorManagerProvider.get()).getMainWikiId().equals(this.getWiki());
    }

    protected DistributionJobStatus createNewDistributionStatus(DistributionRequest request, List<DistributionStep> steps) {
        return new DistributionJobStatus(request, this.observationManager, this.loggerManager, steps);
    }

    protected abstract List<DistributionStep> createSteps();

    protected DistributionJobStatus createNewStatus(R request) {
        List<DistributionStep> steps = this.createSteps();
        if (((DistributionRequest)this.getRequest()).isInteractive()) {
            DistributionStep welcomeStep;
            try {
                welcomeStep = (DistributionStep)this.componentManager.getInstance(DistributionStep.class, "welcome");
                welcomeStep.setState(DistributionStep.State.COMPLETED);
                steps.add(0, welcomeStep);
            }
            catch (ComponentLookupException e1) {
                this.logger.error("Failed to get step instance for id [{}]", (Object)"welcome");
            }
            try {
                welcomeStep = (DistributionStep)this.componentManager.getInstance(DistributionStep.class, "report");
                welcomeStep.setState(DistributionStep.State.COMPLETED);
                steps.add(welcomeStep);
            }
            catch (ComponentLookupException e1) {
                this.logger.error("Failed to get step instance for id [{}]", (Object)"report");
            }
        }
        DistributionJobStatus status = this.createNewDistributionStatus((DistributionRequest)request, steps);
        if (this.distributionManager.getDistributionExtension() != null) {
            DistributionJobStatus previousStatus = this.getPreviousStatus();
            if (previousStatus != null && previousStatus.getDistributionExtension() != null && !Objects.equals(previousStatus.getDistributionExtension(), this.distributionManager.getDistributionExtension().getId())) {
                status.setPreviousDistributionExtension(previousStatus.getDistributionExtension());
                status.setPreviousDistributionExtensionUI(previousStatus.getDistributionExtensionUI());
            }
            status.setDistributionExtension(this.distributionManager.getDistributionExtension().getId());
            status.setDistributionExtensionUI(this.getUIExtensionId());
        }
        return status;
    }

    protected DistributionStep getStep(List<DistributionStep> steps, String stepId) {
        for (DistributionStep step : steps) {
            if (!step.getId().equals(stepId)) continue;
            return step;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() throws Exception {
        List<DistributionStep> steps = ((DistributionJobStatus)this.getStatus()).getSteps();
        this.progressManager.pushLevelProgress(steps.size(), (Object)this);
        WelcomeDistributionStep welcomeStep = (WelcomeDistributionStep)this.getStep(steps, "welcome");
        ReportDistributionStep reportStep = (ReportDistributionStep)this.getStep(steps, "report");
        steps.forEach(s -> s.initialize(this));
        for (DistributionStep step : steps) {
            step.prepare();
            if (step.getState() != null) continue;
            if (welcomeStep == null) break;
            welcomeStep.setState(null);
            reportStep.setState(null);
            break;
        }
        try {
            for (int index = 0; index < steps.size(); ++index) {
                DistributionStep step;
                this.progressManager.startStep((Object)this);
                ((DistributionJobStatus)this.getStatus()).setCurrentStateIndex(index);
                step = steps.get(index);
                step.prepare();
                if (step.getState() == null) {
                    if (((DistributionRequest)this.getRequest()).isInteractive()) {
                        DistributionQuestion question = new DistributionQuestion(step);
                        this.signalReady();
                        ((DistributionJobStatus)this.getStatus()).ask(question);
                        if (question.getAction() != null) {
                            switch (question.getAction()) {
                                case CANCEL: {
                                    while (index < steps.size()) {
                                        steps.get(index).setState(DistributionStep.State.CANCELED);
                                        ++index;
                                    }
                                }
                                case SKIP: {
                                    index = steps.size() - 1;
                                    break;
                                }
                            }
                        }
                        this.store.storeAsync(this.status);
                    } else {
                        step.executeNonInteractive();
                    }
                }
                this.progressManager.endStep((Object)this);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    @Override
    public DistributionStep getCurrentStep() {
        return ((DistributionJobStatus)this.getStatus()).getCurrentStep();
    }

    protected void jobFinished(Throwable exception) {
        super.jobFinished(exception);
        this.signalReady();
        WikiDescriptorManager wikis = (WikiDescriptorManager)this.wikiDescriptorManagerProvider.get();
        if (!this.distributionConfiguration.isInteractiveDistributionWizardEnabledForWiki() && wikis.isMainWiki(this.getWiki())) {
            try {
                Collection wikiIds = wikis.getAllIds();
                Thread distributionJobThread = new Thread(() -> this.runSubWikiDistributions(wikiIds, wikis));
                distributionJobThread.setDaemon(true);
                distributionJobThread.setName("Wikis non-interfactive distribution jobs");
                distributionJobThread.start();
            }
            catch (WikiManagerException e) {
                this.logger.error("Failed to get the list of wikis. Sub-wikis ditribution jobs won't be triggered.", (Throwable)e);
            }
        }
    }

    private void runSubWikiDistributions(Collection<String> wikiIds, WikiDescriptorManager wikiManager) {
        ExecutionContext context = new ExecutionContext();
        try {
            this.executionContextManager.initialize(context);
        }
        catch (ExecutionContextException e) {
            throw new RuntimeException("Failed to initialize wiki distribution job execution context", e);
        }
        for (String wikiId : wikiIds) {
            if (wikiManager.isMainWiki(wikiId)) continue;
            try {
                if (this.distributionManager.getWikiJob(wikiId) != null) continue;
                this.logger.info("Start distribution job for wiki [{}]", (Object)wikiId);
                this.distributionManager.startWikiJob(wikiId, false).join();
                this.logger.info("Finished distribution job for wiki [{}]", (Object)wikiId);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    private void signalReady() {
        this.lock.lock();
        try {
            this.readyCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void awaitReady() throws InterruptedException {
        if (this.getStatus() == null || ((DistributionJobStatus)this.getStatus()).getState() == JobStatus.State.RUNNING) {
            this.lock.lockInterruptibly();
            try {
                this.readyCondition.await();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void setProperty(String key, Object value) {
        ((DistributionJobStatus)this.getStatus()).setProperty(key, value);
    }

    @Override
    public Object getProperty(String key) {
        return ((DistributionJobStatus)this.getStatus()).getproperty(key);
    }

    @Override
    public void removeProperty(String key) {
        ((DistributionJobStatus)this.getStatus()).removeProperty(key);
    }
}

