/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal;

import com.xpn.xwiki.XWikiContext;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.event.ActionExecutingEvent;
import org.xwiki.bridge.event.ApplicationReadyEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.distribution.internal.DistributionConfiguration;
import org.xwiki.extension.distribution.internal.DistributionManager;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="DistributionInitializerListener")
@Singleton
public class DistributionInitializerListener
implements EventListener {
    private static final List<Event> EVENTS = Arrays.asList(new ActionExecutingEvent("view"), new ActionExecutingEvent("distribution"), new ApplicationReadyEvent());
    @Inject
    private DistributionManager distributionManager;
    @Inject
    private DistributionConfiguration distributionConfiguration;

    public List<Event> getEvents() {
        return EVENTS;
    }

    public String getName() {
        return "DistributionInitializerListener";
    }

    public void onEvent(Event event, Object arg1, Object arg2) {
        if (event instanceof ApplicationReadyEvent) {
            this.onApplicationReady();
        } else {
            this.onView((XWikiContext)arg2);
        }
    }

    private void onApplicationReady() {
        DistributionManager.DistributionState distributionState;
        if (!this.distributionConfiguration.isInteractiveDistributionWizardEnabledForMainWiki() && (distributionState = this.distributionManager.getFarmDistributionState()) != DistributionManager.DistributionState.NONE) {
            this.startFarmJob();
        }
    }

    private void onView(XWikiContext xcontext) {
        if (this.distributionManager.getCurrentDistributionJob() != null || !this.isAutoDistributionWizardEnabled(xcontext)) {
            return;
        }
        DistributionManager.DistributionState distributionState = this.distributionManager.getFarmDistributionState();
        if (distributionState != DistributionManager.DistributionState.NONE && this.distributionManager.canDisplayDistributionWizard()) {
            if (xcontext.isMainWiki()) {
                if (this.distributionManager.getFarmJob() == null) {
                    this.startFarmJob();
                }
            } else {
                String wiki = xcontext.getWikiId();
                if (this.distributionManager.getWikiJob(wiki) == null) {
                    this.startWikiJob(wiki);
                }
            }
        }
    }

    private boolean isAutoDistributionWizardEnabled(XWikiContext xcontext) {
        return xcontext.isMainWiki() ? this.distributionConfiguration.isAutoDistributionWizardEnabledForMainWiki() : this.distributionConfiguration.isAutoDistributionWizardEnabledForWiki();
    }

    private synchronized void startFarmJob() {
        if (this.distributionManager.getFarmJob() == null) {
            this.distributionManager.startFarmJob();
        }
    }

    private synchronized void startWikiJob(String wiki) {
        if (this.distributionManager.getWikiJob(wiki) == null) {
            this.distributionManager.startWikiJob(wiki, true);
        }
    }
}

