/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.store.solr.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.solr.client.solrj.SolrClient;
import org.slf4j.Logger;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.search.solr.Solr;
import org.xwiki.search.solr.SolrUtils;

@Component
@Named(value="org.xwiki.eventstream.store.solr.internal.WikiDeletedListener")
@Singleton
public class WikiDeletedListener
extends AbstractEventListener {
    public static final String NAME = "org.xwiki.eventstream.store.solr.internal.WikiDeletedListener";
    @Inject
    private Solr solr;
    @Inject
    private SolrUtils utils;
    @Inject
    private Logger logger;

    public WikiDeletedListener() {
        super(NAME, new Event[]{new WikiDeletedEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        WikiDeletedEvent wikiDeletedEvent = (WikiDeletedEvent)event;
        try {
            SolrClient client = this.solr.getClient("events");
            client.deleteByQuery("wiki:" + this.utils.toCompleteFilterQueryString((Object)wikiDeletedEvent.getWikiId()));
            client.commit();
        }
        catch (Exception e) {
            this.logger.error("Failed to delete events associated with wiki [{}]", (Object)wikiDeletedEvent.getWikiId(), (Object)e);
        }
    }
}

