/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.store.solr.internal;

import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.eventstream.EntityEvent;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventQuery;
import org.xwiki.eventstream.EventSearchResult;
import org.xwiki.eventstream.EventStatus;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.internal.AbstractAsynchronousEventStore;
import org.xwiki.eventstream.internal.DefaultEvent;
import org.xwiki.eventstream.internal.DefaultEventStatus;
import org.xwiki.eventstream.internal.StreamEventSearchResult;
import org.xwiki.eventstream.query.AbstractPropertyQueryCondition;
import org.xwiki.eventstream.query.CompareQueryCondition;
import org.xwiki.eventstream.query.GroupQueryCondition;
import org.xwiki.eventstream.query.InQueryCondition;
import org.xwiki.eventstream.query.MailEntityQueryCondition;
import org.xwiki.eventstream.query.PageableEventQuery;
import org.xwiki.eventstream.query.QueryCondition;
import org.xwiki.eventstream.query.SimpleEventQuery;
import org.xwiki.eventstream.query.SortableEventQuery;
import org.xwiki.eventstream.query.StatusQueryCondition;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.search.solr.Solr;
import org.xwiki.search.solr.SolrException;
import org.xwiki.search.solr.SolrUtils;

@Component
@Singleton
@Named(value="solr")
public class SolrEventStore
extends AbstractAsynchronousEventStore {
    private static final Map<String, SearchFieldMapping> SEARCH_FIELD_MAPPING = new HashMap<String, SearchFieldMapping>();
    @Inject
    private Solr solr;
    @Inject
    private SolrUtils utils;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    @Named(value="compact")
    private EntityReferenceSerializer<String> compact;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactwiki;
    private SolrClient client;

    public void initialize() throws InitializationException {
        this.initialize(100, false, true);
        try {
            this.client = this.solr.getClient("events");
        }
        catch (SolrException e) {
            throw new InitializationException("Failed to get the events Solr core", (Throwable)e);
        }
    }

    protected void afterTasks(List<AbstractAsynchronousEventStore.EventStoreTask<?, ?>> tasks) {
        try {
            this.commit();
        }
        catch (EventStreamException e) {
            this.logger.error("Failed to commit", (Throwable)e);
        }
        super.afterTasks(tasks);
    }

    protected Event syncSaveEvent(Event event) throws EventStreamException {
        try {
            this.client.add(this.toSolrInputDocument(event));
        }
        catch (Exception e) {
            throw new EventStreamException("Failed to save event", (Throwable)e);
        }
        return event;
    }

    protected EventStatus syncSaveEventStatus(EventStatus status) throws EventStreamException {
        this.saveEventStatus(status.getEvent().getId(), status.getEntityId(), status.isRead(), !status.isRead());
        return status;
    }

    protected EntityEvent syncSaveMailEntityEvent(EntityEvent event) throws EventStreamException {
        this.saveMailEntityEvent(event.getEvent().getId(), event.getEntityId(), true);
        return event;
    }

    protected Optional<EventStatus> syncDeleteEventStatus(EventStatus status) throws EventStreamException {
        this.saveEventStatus(status.getEvent().getId(), status.getEntityId(), false, false);
        return Optional.of(status);
    }

    protected Void syncDeleteEventStatuses(String entityId, Date date) throws EventStreamException {
        SimpleEventQuery query = new SimpleEventQuery();
        query.withStatus(entityId);
        if (date != null) {
            query.lessOrEq("date", (Object)date);
        }
        EventSearchResult results = this.search((EventQuery)query, Collections.singleton("id"));
        Iterator it = results.stream().iterator();
        while (it.hasNext()) {
            Event event = (Event)it.next();
            this.saveEventStatus(event.getId(), entityId, false, false);
        }
        return null;
    }

    protected Optional<EntityEvent> syncDeleteMailEntityEvent(EntityEvent event) throws EventStreamException {
        this.saveMailEntityEvent(event.getEvent().getId(), event.getEntityId(), false);
        return Optional.of(event);
    }

    protected Event syncPrefilterEvent(Event event) throws EventStreamException {
        SolrInputDocument document = new SolrInputDocument();
        this.utils.set("id", (Object)event.getId(), document);
        this.utils.setAtomic("set", "preFiltered", (Object)true, document);
        try {
            this.client.add(document);
        }
        catch (Exception e) {
            throw new EventStreamException(String.format("Failed to to set the event [%s] as prefiltered", event.getId()), (Throwable)e);
        }
        if (event instanceof DefaultEvent) {
            event.setPrefiltered(true);
        }
        return event;
    }

    private void saveEventStatus(String eventId, String entityId, boolean read, boolean unread) throws EventStreamException {
        SolrInputDocument document = new SolrInputDocument();
        this.utils.set("id", (Object)eventId, document);
        this.utils.setAtomic(read ? "add-distinct" : "remove", "readListeners", (Object)entityId, document);
        this.utils.setAtomic(unread ? "add-distinct" : "remove", "unreadListeners", (Object)entityId, document);
        try {
            this.client.add(document);
        }
        catch (Exception e) {
            throw new EventStreamException(String.format("Failed to update the event status for event [%s] and entity id [%s]", eventId, entityId), (Throwable)e);
        }
    }

    private void saveMailEntityEvent(String eventId, String entityId, boolean add) throws EventStreamException {
        SolrInputDocument document = new SolrInputDocument();
        this.utils.set("id", (Object)eventId, document);
        this.utils.setAtomic(add ? "add-distinct" : "remove", "mailListeners", (Object)entityId, document);
        try {
            this.client.add(document);
        }
        catch (Exception e) {
            throw new EventStreamException(String.format("Failed to update the event mail status for event [%s] and entity id [%s]", eventId, entityId), (Throwable)e);
        }
    }

    private SolrInputDocument toSolrInputDocument(Event event) {
        if (event == null) {
            return null;
        }
        SolrInputDocument document = new SolrInputDocument();
        this.utils.set("id", (Object)event.getId(), document);
        this.utils.set("application", (Object)event.getApplication(), document);
        this.utils.set("body", (Object)event.getBody(), document);
        this.utils.set("date", (Object)event.getDate(), document);
        this.utils.set("observationInstanceId", (Object)event.getRemoteObservationId(), document);
        this.utils.setString("document", (Object)event.getDocument(), document);
        this.utils.set("documentTitle", (Object)event.getDocumentTitle(), document);
        this.utils.set("documentVersion", (Object)event.getDocumentVersion(), document);
        this.utils.set("groupId", (Object)event.getGroupId(), document);
        this.utils.set("hidden", (Object)event.getHidden(), document);
        this.utils.set("preFiltered", (Object)event.isPrefiltered(), document);
        this.utils.setString("importance", (Object)event.getImportance(), document);
        this.utils.setString("relatedEntity", (Object)event.getRelatedEntity(), EntityReference.class, document);
        this.utils.setString("space", (Object)event.getSpace(), document);
        this.utils.set("stream", (Object)event.getStream(), document);
        this.utils.set("target", (Collection)event.getTarget(), document);
        this.utils.set("title", (Object)event.getTitle(), document);
        this.utils.set("type", (Object)event.getType(), document);
        this.utils.setString("url", (Object)event.getUrl(), document);
        this.utils.setString("user", (Object)event.getUser(), document);
        this.utils.setString("wiki", (Object)event.getWiki(), document);
        this.utils.setMap("properties", event.getCustom(), document);
        if (event.getDocument() != null) {
            this.utils.set("document_index", Arrays.asList((String)this.serializer.serialize((EntityReference)event.getDocument(), new Object[0]), (String)this.compactwiki.serialize((EntityReference)event.getDocument(), new Object[]{event.getWiki()}), (String)this.compact.serialize((EntityReference)event.getDocument(), new Object[]{event.getSpace()})), document);
        }
        if (event.getSpace() != null) {
            this.utils.set("space_index", Arrays.asList((String)this.serializer.serialize((EntityReference)event.getSpace(), new Object[0]), (String)this.compact.serialize((EntityReference)event.getSpace(), new Object[]{event.getWiki()})), document);
        }
        return document;
    }

    protected Optional<Event> syncDeleteEvent(String eventId) throws EventStreamException {
        Optional<Event> event = this.getEvent(eventId);
        if (event.isPresent()) {
            this.deleteById(eventId);
        }
        return event;
    }

    protected Optional<Event> syncDeleteEvent(Event event) throws EventStreamException {
        return this.syncDeleteEvent(event.getId());
    }

    private void deleteById(String eventId) throws EventStreamException {
        try {
            this.client.deleteById(eventId);
        }
        catch (Exception e) {
            throw new EventStreamException("Failed to delete the event", (Throwable)e);
        }
    }

    private void commit() throws EventStreamException {
        try {
            this.client.commit();
        }
        catch (Exception e) {
            throw new EventStreamException("Failed to commit", (Throwable)e);
        }
    }

    public SolrDocument getEventDocument(String eventId) throws SolrServerException, IOException {
        return this.client.getById(eventId);
    }

    public Optional<Event> getEvent(String eventId) throws EventStreamException {
        SolrDocument document;
        try {
            document = this.getEventDocument(eventId);
        }
        catch (Exception e) {
            throw new EventStreamException("Failed to get Solr document with id [" + eventId + "]", (Throwable)e);
        }
        return Optional.ofNullable(this.toEvent(document));
    }

    public List<EventStatus> getEventStatuses(Collection<Event> events, Collection<String> entityIds) throws Exception {
        QueryResponse response;
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.addFilterQuery(new String[]{this.serializeInCondition("id", events.stream().map(Event::getId).collect(Collectors.toList()))});
        solrQuery.addFilterQuery(new String[]{this.serializeInCondition("readListeners", entityIds) + " OR " + this.serializeInCondition("unreadListeners", entityIds)});
        solrQuery.setRows(Integer.valueOf(events.size()));
        try {
            response = this.client.query((SolrParams)solrQuery);
        }
        catch (Exception e) {
            throw new EventStreamException("Failed to execute Solr query", (Throwable)e);
        }
        SolrDocumentList documents = response.getResults();
        ArrayList<EventStatus> statuses = new ArrayList<EventStatus>(documents.size() * entityIds.size());
        for (SolrDocument solrDocument : documents) {
            Event event = this.toEvent(solrDocument);
            Set readListeners = this.utils.getSet("readListeners", solrDocument);
            Set unreadListeners = this.utils.getSet("unreadListeners", solrDocument);
            for (String entityId : entityIds) {
                boolean unread;
                boolean read = readListeners != null && readListeners.contains(entityId);
                boolean bl = unread = unreadListeners != null && unreadListeners.contains(entityId);
                if (!read && !unread) continue;
                statuses.add((EventStatus)new DefaultEventStatus(event, entityId, read));
            }
        }
        return statuses;
    }

    private Event toEvent(SolrDocument document) {
        if (document == null) {
            return null;
        }
        DefaultEvent event = new DefaultEvent();
        event.setId((String)this.utils.get("id", document));
        event.setApplication((String)this.utils.get("application", document));
        event.setBody((String)this.utils.get("body", document));
        event.setDate((Date)this.utils.get("date", document));
        event.setRemoteObservationId((String)this.utils.get("observationInstanceId", document));
        event.setDocument((DocumentReference)this.utils.get("document", document, DocumentReference.class));
        event.setDocumentTitle((String)this.utils.get("documentTitle", document));
        event.setDocumentVersion((String)this.utils.get("documentVersion", document));
        event.setGroupId((String)this.utils.get("groupId", document));
        event.setImportance((Event.Importance)this.utils.get("importance", document, Event.Importance.class));
        event.setRelatedEntity((EntityReference)this.utils.get("relatedEntity", document, EntityReference.class));
        event.setSpace((SpaceReference)this.utils.get("space", document, SpaceReference.class));
        event.setStream((String)this.utils.get("stream", document));
        event.setTarget(this.utils.getSet("target", document));
        event.setTitle((String)this.utils.get("title", document));
        event.setType((String)this.utils.get("type", document));
        event.setUrl((URL)this.utils.get("url", document, URL.class));
        event.setUser((DocumentReference)this.utils.get("user", document, DocumentReference.class));
        event.setWiki((WikiReference)this.utils.get("wiki", document, WikiReference.class));
        event.setHidden(((Boolean)this.utils.get("hidden", document, (Object)false)).booleanValue());
        event.setPrefiltered(((Boolean)this.utils.get("preFiltered", document, (Object)false)).booleanValue());
        event.setParameters(this.utils.getMap("properties", document));
        return event;
    }

    private SolrQuery toSolrQuery(EventQuery query, Set<String> fields) {
        SolrQuery solrQuery = new SolrQuery();
        if (CollectionUtils.isNotEmpty(fields)) {
            fields.forEach(xva$0 -> solrQuery.setFields(new String[]{xva$0}));
        }
        if (query instanceof PageableEventQuery) {
            PageableEventQuery pageableQuery = (PageableEventQuery)query;
            if (pageableQuery.getOffset() > 0L) {
                solrQuery.setStart(Integer.valueOf((int)pageableQuery.getOffset()));
            }
            if (pageableQuery.getLimit() >= 0L) {
                solrQuery.setRows(Integer.valueOf((int)pageableQuery.getLimit()));
            } else {
                solrQuery.setRows(Integer.valueOf(0x7FFFFFFE));
            }
        }
        if (query instanceof SortableEventQuery) {
            for (SortableEventQuery.SortClause sort : ((SortableEventQuery)query).getSorts()) {
                solrQuery.addSort(this.toSolrFieldName(sort), sort.getOrder() == SortableEventQuery.SortClause.Order.ASC ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
            }
        }
        if (query instanceof SimpleEventQuery) {
            SimpleEventQuery simpleQuery = (SimpleEventQuery)query;
            this.addConditions((List<QueryCondition>)(simpleQuery.isOr() && simpleQuery.getConditions().size() > 1 ? Collections.singletonList(simpleQuery) : simpleQuery.getConditions()), solrQuery);
        }
        return solrQuery;
    }

    private void addConditions(List<QueryCondition> conditions, SolrQuery solrQuery) {
        for (QueryCondition condition : conditions) {
            String conditionString = this.serializeCondition(condition);
            if (conditionString == null) continue;
            if (condition.isReversed()) {
                solrQuery.addFilterQuery(new String[]{"-" + conditionString});
                continue;
            }
            solrQuery.addFilterQuery(new String[]{conditionString});
        }
    }

    private String serializeCondition(QueryCondition condition) {
        String conditionString = condition instanceof CompareQueryCondition ? this.serializeCompareCondition((CompareQueryCondition)condition) : (condition instanceof StatusQueryCondition ? this.serializeStatusCondition((StatusQueryCondition)condition) : (condition instanceof MailEntityQueryCondition ? this.serializeMailCondition((MailEntityQueryCondition)condition) : (condition instanceof InQueryCondition ? this.serializeInCondition((InQueryCondition)condition) : (condition instanceof GroupQueryCondition ? this.serializeGroupCondition((GroupQueryCondition)condition) : null))));
        return conditionString;
    }

    private String serializeStatusCondition(StatusQueryCondition condition) {
        if (condition.getStatusRead() != null) {
            StringBuilder builder = new StringBuilder();
            if (condition.getStatusEntityId() != null) {
                builder.append(condition.getStatusRead() != false ? "readListeners" : "unreadListeners");
                builder.append(':');
                builder.append(this.utils.toCompleteFilterQueryString((Object)condition.getStatusEntityId()));
            } else {
                builder.append('(');
                builder.append("readListeners");
                builder.append(':');
                builder.append("[* TO *]");
                builder.append(" OR ");
                builder.append("unreadListeners");
                builder.append(':');
                builder.append("[* TO *]");
                builder.append(')');
            }
            return builder.toString();
        }
        if (condition.getStatusEntityId() != null) {
            StringBuilder builder = new StringBuilder();
            builder.append('(');
            builder.append("readListeners");
            builder.append(':');
            builder.append(this.utils.toCompleteFilterQueryString((Object)condition.getStatusEntityId()));
            builder.append(" OR ");
            builder.append("unreadListeners");
            builder.append(':');
            builder.append(this.utils.toCompleteFilterQueryString((Object)condition.getStatusEntityId()));
            builder.append(')');
            return builder.toString();
        }
        return null;
    }

    private String serializeMailCondition(MailEntityQueryCondition condition) {
        if (condition.getStatusEntityId() != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("mailListeners");
            builder.append(':');
            builder.append(this.utils.toCompleteFilterQueryString((Object)condition.getStatusEntityId()));
            return builder.toString();
        }
        return null;
    }

    private String serializeInCondition(InQueryCondition condition) {
        return this.serializeInCondition(this.toSearchFieldName(this.toSolrFieldName((AbstractPropertyQueryCondition)condition)), condition.getValues());
    }

    private String serializeInCondition(String filedName, Collection<?> values) {
        StringBuilder builder = new StringBuilder();
        builder.append(filedName);
        builder.append(':');
        if (values.isEmpty()) {
            builder.append("[* TO *]");
            return "(-" + builder.toString() + ")";
        }
        builder.append('(');
        builder.append(StringUtils.join(values.stream().map(arg_0 -> ((SolrUtils)this.utils).toCompleteFilterQueryString(arg_0)).iterator(), (String)" OR "));
        builder.append(')');
        return builder.toString();
    }

    private String serializeGroupCondition(GroupQueryCondition group) {
        if (group.getConditions().isEmpty()) {
            return null;
        }
        if (group.getConditions().size() == 1) {
            return this.serializeCondition((QueryCondition)group.getConditions().get(0));
        }
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (QueryCondition condition : group.getConditions()) {
            String conditionString;
            if (builder.length() > 1) {
                if (group.isOr()) {
                    builder.append(" OR ");
                } else {
                    builder.append(" AND ");
                }
            }
            if ((conditionString = this.serializeCondition(condition)) == null) continue;
            if (condition.isReversed()) {
                builder.append('-');
            }
            builder.append(conditionString);
        }
        builder.append(')');
        return builder.toString();
    }

    private String getMapFieldName(String key, Type type) {
        return this.utils.getMapFieldName(key, "properties", type);
    }

    private String toSolrFieldName(AbstractPropertyQueryCondition condition) {
        if (condition.isCustom()) {
            Class<?> customType = condition.getCustomType();
            if (customType == null) {
                List values;
                Object value = null;
                if (condition instanceof CompareQueryCondition) {
                    value = ((CompareQueryCondition)condition).getValue();
                } else if (condition instanceof InQueryCondition && (values = ((InQueryCondition)condition).getValues()) != null && !values.isEmpty()) {
                    value = values.get(0);
                }
                if (value != null) {
                    customType = value.getClass();
                }
            }
            return this.getMapFieldName(condition.getProperty(), customType);
        }
        return condition.getProperty();
    }

    private String toSolrFieldName(SortableEventQuery.SortClause sort) {
        if (sort.isCustom()) {
            return this.getMapFieldName(sort.getProperty(), sort.getCustomType());
        }
        return sort.getProperty();
    }

    private String serializeCompareCondition(CompareQueryCondition condition) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.toSearchFieldName(this.toSolrFieldName((AbstractPropertyQueryCondition)condition)));
        builder.append(':');
        switch (condition.getType()) {
            case EQUALS: {
                String queryString = this.toCompleteFilterQueryString(condition.getProperty(), condition.getValue());
                if (queryString == null) {
                    builder.insert(0, "(*:* NOT ");
                    builder.append("*)");
                    break;
                }
                builder.append(queryString);
                break;
            }
            case LESS: 
            case LESS_OR_EQUALS: {
                builder.append(this.toFilterQueryStringRange(null, condition));
                break;
            }
            case GREATER: 
            case GREATER_OR_EQUALS: {
                builder.append(this.toFilterQueryStringRange(condition, null));
                break;
            }
            case STARTS_WITH: {
                builder.append(this.utils.toFilterQueryString(condition.getValue()));
                builder.append('*');
                break;
            }
            case ENDS_WITH: {
                builder.append('*');
                builder.append(this.utils.toFilterQueryString(condition.getValue()));
                break;
            }
            case CONTAINS: {
                builder.append('*');
                builder.append(this.utils.toFilterQueryString(condition.getValue()));
                builder.append('*');
            }
        }
        return builder.toString();
    }

    private String toCompleteFilterQueryString(String propertyName, Object propertyValue) {
        SearchFieldMapping mapping = SEARCH_FIELD_MAPPING.get(propertyName);
        if (mapping != null && mapping.type != null) {
            return this.utils.toCompleteFilterQueryString(propertyValue, mapping.type);
        }
        return this.utils.toCompleteFilterQueryString(propertyValue);
    }

    private String toSearchFieldName(String property) {
        SearchFieldMapping mapping = SEARCH_FIELD_MAPPING.get(property);
        if (mapping != null && mapping.solrFieldName != null) {
            return mapping.solrFieldName;
        }
        return property;
    }

    private String toFilterQueryStringRange(CompareQueryCondition greater, CompareQueryCondition less) {
        StringBuilder builder = new StringBuilder();
        if (greater != null) {
            if (greater.getType() == CompareQueryCondition.CompareType.GREATER) {
                builder.append('{');
            } else {
                builder.append('[');
            }
            builder.append(this.utils.toCompleteFilterQueryString(greater.getValue()));
        } else {
            builder.append("[*");
        }
        builder.append(" TO ");
        if (less != null) {
            builder.append(this.utils.toCompleteFilterQueryString(less.getValue()));
            if (less.getType() == CompareQueryCondition.CompareType.LESS) {
                builder.append('}');
            } else {
                builder.append(']');
            }
        } else {
            builder.append("*]");
        }
        return builder.toString();
    }

    public EventSearchResult search(EventQuery query) throws EventStreamException {
        return this.search(query, null);
    }

    public EventSearchResult search(EventQuery query, Set<String> fields) throws EventStreamException {
        QueryResponse response;
        SolrQuery solrQuery = this.toSolrQuery(query, fields);
        try {
            response = this.client.query((SolrParams)solrQuery);
        }
        catch (Exception e) {
            throw new EventStreamException("Failed to execute Solr query", (Throwable)e);
        }
        SolrDocumentList documents = response.getResults();
        return new StreamEventSearchResult(documents.getNumFound(), documents.getStart(), (long)documents.size(), documents.stream().map(this::toEvent));
    }

    static {
        SEARCH_FIELD_MAPPING.put("document", new SearchFieldMapping("document_index"));
        SEARCH_FIELD_MAPPING.put("space", new SearchFieldMapping("space_index"));
        SEARCH_FIELD_MAPPING.put("relatedEntity", new SearchFieldMapping((Type)((Object)EntityReference.class)));
        SEARCH_FIELD_MAPPING.put("importance", new SearchFieldMapping((Type)((Object)Event.Importance.class)));
        SEARCH_FIELD_MAPPING.put("user", new SearchFieldMapping((Type)((Object)DocumentReference.class)));
    }

    private static class SearchFieldMapping {
        String solrFieldName;
        Type type;

        SearchFieldMapping(String solrFieldName) {
            this.solrFieldName = solrFieldName;
        }

        SearchFieldMapping(Type type) {
            this.type = type;
        }

        SearchFieldMapping(String solrFieldName, Type type) {
            this.solrFieldName = solrFieldName;
            this.type = type;
        }
    }
}

