/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.store.internal;

import com.xpn.xwiki.internal.event.XObjectDeletedEvent;
import com.xpn.xwiki.internal.mandatory.XWikiUsersDocumentInitializer;
import com.xpn.xwiki.objects.BaseObjectReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.EventStore;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="org.xwiki.eventstream.store.internal.UserDeletedEventListener")
public class UserDeletedEventListener
extends AbstractEventListener {
    public static final String NAME = "org.xwiki.eventstream.store.internal.UserDeletedEventListener";
    @Inject
    private EventStore eventStore;
    @Inject
    private EntityReferenceSerializer<String> serializer;

    public UserDeletedEventListener() {
        super(NAME, new Event[]{new XObjectDeletedEvent((EntityReference)BaseObjectReference.any((String)XWikiUsersDocumentInitializer.CLASS_REFERENCE_STRING))});
    }

    public void onEvent(Event event, Object source, Object data) {
        EntityReference userReference = ((XObjectDeletedEvent)event).getReference().extractReference(EntityType.DOCUMENT);
        String entity = (String)this.serializer.serialize(userReference, new Object[0]);
        this.eventStore.deleteEventStatuses(entity, null);
    }
}

