/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.store.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventStore;
import org.xwiki.eventstream.RecordableEvent;
import org.xwiki.eventstream.RecordableEventConverter;
import org.xwiki.eventstream.store.internal.DocumentEventListener;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.ObservationContext;
import org.xwiki.observation.event.AllEvent;
import org.xwiki.observation.event.BeginEvent;
import org.xwiki.observation.event.BeginFoldEvent;
import org.xwiki.observation.remote.RemoteObservationManagerContext;

@Component
@Singleton
@Named(value="RecordableEventListener")
public class RecordableEventListener
extends AbstractEventListener {
    private static final BeginFoldEvent IGNORED_EVENTS = otherEvent -> otherEvent instanceof BeginFoldEvent;
    @Inject
    private EventStore eventStore;
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private RecordableEventConverter defaultConverter;
    @Inject
    private RemoteObservationManagerContext remoteObservationManagerContext;
    @Inject
    private ObservationContext observationContext;
    @Inject
    private Logger logger;

    public RecordableEventListener() {
        super("RecordableEventListener", new org.xwiki.observation.event.Event[]{AllEvent.ALLEVENT});
    }

    public void onEvent(org.xwiki.observation.event.Event event, Object source, Object data) {
        if (!(event instanceof RecordableEvent) || this.remoteObservationManagerContext.isRemoteState() || this.observationContext.isIn((BeginEvent)IGNORED_EVENTS)) {
            return;
        }
        for (org.xwiki.observation.event.Event ignoredEvent : DocumentEventListener.LISTENER_EVENTS) {
            if (!ignoredEvent.matches((Object)event)) continue;
            return;
        }
        try {
            this.eventStore.saveEvent(this.convertEvent(event, source, data)).whenComplete((e, ex) -> {
                if (ex != null) {
                    this.logger.warn("Failed to save the event [{}].", (Object)event.getClass().getCanonicalName(), ex);
                }
            });
        }
        catch (Exception e2) {
            this.logger.warn("Failed to convert event [{}].", (Object)event.getClass().getCanonicalName(), (Object)e2);
        }
    }

    private Event convertEvent(org.xwiki.observation.event.Event event, Object source, Object data) throws Exception {
        for (RecordableEventConverter converter : this.componentManager.getInstanceList(RecordableEventConverter.class)) {
            if (converter == this.defaultConverter) continue;
            for (RecordableEvent ev : converter.getSupportedEvents()) {
                if (!ev.matches((Object)event)) continue;
                return converter.convert((RecordableEvent)event, (String)source, data);
            }
        }
        return this.defaultConverter.convert((RecordableEvent)event, (String)source, data);
    }
}

