/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.store.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.AttachmentAddedEvent;
import com.xpn.xwiki.internal.event.AttachmentDeletedEvent;
import com.xpn.xwiki.internal.event.AttachmentUpdatedEvent;
import com.xpn.xwiki.internal.event.CommentAddedEvent;
import com.xpn.xwiki.internal.event.CommentDeletedEvent;
import com.xpn.xwiki.internal.event.CommentUpdatedEvent;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.annotation.event.AnnotationAddedEvent;
import org.xwiki.annotation.event.AnnotationDeletedEvent;
import org.xwiki.annotation.event.AnnotationUpdatedEvent;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventFactory;
import org.xwiki.eventstream.EventStore;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.user.UserReferenceSerializer;

@Component(roles={DocumentEventRecorder.class})
@Singleton
public class DocumentEventRecorder {
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private EventStore eventStore;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    @Named(value="document")
    private UserReferenceSerializer<DocumentReference> userReferenceSerializer;
    @Inject
    private EventFactory eventFactory;

    public void recordEvent(org.xwiki.observation.event.Event event, Object source) throws EventStreamException, InterruptedException, ExecutionException {
        String eventType;
        XWikiDocument currentDoc = (XWikiDocument)source;
        XWikiDocument originalDoc = currentDoc.getOriginalDocument();
        String streamName = (String)this.serializer.serialize((EntityReference)currentDoc.getDocumentReference().getLastSpaceReference(), new Object[0]);
        if (streamName == null) {
            return;
        }
        if (event instanceof DocumentCreatedEvent) {
            eventType = "create";
        } else if (event instanceof DocumentUpdatedEvent) {
            eventType = "update";
        } else if (event instanceof DocumentDeletedEvent) {
            eventType = "delete";
            currentDoc.setVersion(originalDoc.getVersion());
            currentDoc.setHidden(originalDoc.isHidden());
        } else if (event instanceof CommentAddedEvent) {
            eventType = "addComment";
        } else if (event instanceof CommentDeletedEvent) {
            eventType = "deleteComment";
        } else if (event instanceof CommentUpdatedEvent) {
            eventType = "updateComment";
        } else if (event instanceof AttachmentAddedEvent) {
            eventType = "addAttachment";
        } else if (event instanceof AttachmentDeletedEvent) {
            eventType = "deleteAttachment";
        } else if (event instanceof AttachmentUpdatedEvent) {
            eventType = "updateAttachment";
        } else if (event instanceof AnnotationAddedEvent) {
            eventType = "addAnnotation";
        } else if (event instanceof AnnotationDeletedEvent) {
            eventType = "deleteAnnotation";
        } else if (event instanceof AnnotationUpdatedEvent) {
            eventType = "updateAnnotation";
        } else {
            return;
        }
        this.recordEvent(streamName, currentDoc, eventType, eventType);
    }

    private void recordEvent(String streamName, XWikiDocument doc, String type, String title) {
        String msgPrefix = "activitystream.event.";
        Event event = this.eventFactory.createRawEvent();
        event.setStream(streamName);
        event.setDocument(doc.getDocumentReference());
        event.setDate(doc.getDate());
        event.setImportance(Event.Importance.MEDIUM);
        event.setType(type);
        event.setTitle("activitystream.event." + title);
        event.setBody("activitystream.event." + title);
        event.setDocumentVersion(doc.getVersion());
        DocumentReference originalAuthor = (DocumentReference)this.userReferenceSerializer.serialize(doc.getAuthors().getOriginalMetadataAuthor());
        event.setUser(originalAuthor);
        event.setHidden(doc.isHidden().booleanValue());
        event.setDocumentTitle(doc.getRenderedTitle(Syntax.PLAIN_1_0, (XWikiContext)this.contextProvider.get()));
        this.eventStore.saveEvent(event);
    }
}

