/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.store.internal;

import com.xpn.xwiki.internal.event.AttachmentAddedEvent;
import com.xpn.xwiki.internal.event.AttachmentDeletedEvent;
import com.xpn.xwiki.internal.event.AttachmentUpdatedEvent;
import com.xpn.xwiki.internal.event.CommentAddedEvent;
import com.xpn.xwiki.internal.event.CommentDeletedEvent;
import com.xpn.xwiki.internal.event.CommentUpdatedEvent;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.annotation.event.AnnotationAddedEvent;
import org.xwiki.annotation.event.AnnotationDeletedEvent;
import org.xwiki.annotation.event.AnnotationUpdatedEvent;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.eventstream.store.internal.DocumentEventRecorder;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.ObservationContext;
import org.xwiki.observation.event.BeginEvent;
import org.xwiki.observation.event.BeginFoldEvent;
import org.xwiki.observation.event.Event;
import org.xwiki.observation.remote.RemoteObservationManagerContext;

@Component
@Singleton
@Named(value="EventStreamStoreListener")
public class DocumentEventListener
extends AbstractEventListener {
    public static final List<Event> LISTENER_EVENTS = new ArrayList<Event>(){
        {
            this.add(new DocumentCreatedEvent());
            this.add(new DocumentUpdatedEvent());
            this.add(new DocumentDeletedEvent());
            this.add(new CommentAddedEvent());
            this.add(new CommentDeletedEvent());
            this.add(new CommentUpdatedEvent());
            this.add(new AttachmentAddedEvent());
            this.add(new AttachmentDeletedEvent());
            this.add(new AttachmentUpdatedEvent());
            this.add(new AnnotationAddedEvent());
            this.add(new AnnotationDeletedEvent());
            this.add(new AnnotationUpdatedEvent());
        }
    };
    private static final BeginFoldEvent IGNORED_EVENTS = otherEvent -> otherEvent instanceof BeginFoldEvent;
    @Inject
    private RemoteObservationManagerContext remoteObservationManagerContext;
    @Inject
    private ObservationContext observationContext;
    @Inject
    private Logger logger;
    @Inject
    private Execution execution;
    @Inject
    private DocumentEventRecorder documentEventRecorder;

    public DocumentEventListener() {
        super("EventStreamStoreListener", LISTENER_EVENTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event event, Object source, Object data) {
        if (this.remoteObservationManagerContext.isRemoteState() || this.observationContext.isIn((BeginEvent)IGNORED_EVENTS) || this.execution.getContext().hasProperty("eventLoopContextLockProperty")) {
            return;
        }
        try {
            this.execution.getContext().setProperty("eventLoopContextLockProperty", (Object)true);
            for (Event ignoredEvent : LISTENER_EVENTS) {
                if (!ignoredEvent.matches((Object)event)) continue;
                this.documentEventRecorder.recordEvent(event, source);
                return;
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to save the event [{}].", (Object)event.getClass().getCanonicalName(), (Object)e);
        }
        finally {
            this.execution.getContext().removeProperty("eventLoopContextLockProperty");
        }
    }
}

