/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.internal.observation;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.EntityEvent;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventStore;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.events.MailEntityAddedEvent;
import org.xwiki.eventstream.events.MailEntityDeleteEvent;
import org.xwiki.eventstream.internal.DefaultEntityEvent;
import org.xwiki.observation.remote.LocalEventData;
import org.xwiki.observation.remote.RemoteEventData;
import org.xwiki.observation.remote.converter.AbstractEventConverter;

@Component
@Singleton
@Named(value="mailentity")
public class MailEntityEventConverter
extends AbstractEventConverter {
    private static final Set<Class<? extends org.xwiki.observation.event.Event>> EVENTS = new HashSet<Class>(Arrays.asList(MailEntityAddedEvent.class, MailEntityDeleteEvent.class));
    private static final String PROP_EVENTID = "eventId";
    private static final String PROP_ENTITYID = "entityId";
    @Inject
    private EventStore store;
    @Inject
    private Logger logger;

    public boolean toRemote(LocalEventData localEvent, RemoteEventData remoteEvent) {
        if (EVENTS.contains(localEvent.getEvent().getClass())) {
            remoteEvent.setEvent((Serializable)localEvent.getEvent());
            remoteEvent.setSource(this.serializeEntityEvent((EntityEvent)localEvent.getSource()));
            return true;
        }
        return false;
    }

    private Serializable serializeEntityEvent(EntityEvent local) {
        Serializable remote = null;
        if (local != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(PROP_EVENTID, local.getEvent().getId());
            map.put(PROP_ENTITYID, local.getEntityId());
            remote = map;
        }
        return remote;
    }

    public boolean fromRemote(RemoteEventData remoteEvent, LocalEventData localEvent) {
        if (EVENTS.contains(remoteEvent.getEvent().getClass())) {
            try {
                localEvent.setEvent((org.xwiki.observation.event.Event)remoteEvent.getEvent());
                localEvent.setSource(this.unserializeEntityEvent(remoteEvent.getSource()));
                return true;
            }
            catch (Exception e) {
                this.logger.error("Failed to convert remote event [{}]", (Object)remoteEvent, (Object)e);
            }
        }
        return false;
    }

    private Object unserializeEntityEvent(Serializable remote) throws EventStreamException {
        if (remote instanceof Map) {
            Map map = (Map)((Object)remote);
            String eventId = (String)map.get(PROP_EVENTID);
            Optional event = this.store.getEvent(eventId);
            if (event.isPresent()) {
                return new DefaultEntityEvent((Event)event.get(), (String)map.get(PROP_ENTITYID));
            }
            this.logger.warn("Could not find any event corresponding to the remote event with id [{}]", (Object)eventId);
        }
        return null;
    }
}

