/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.namespace.NamespaceContextExecutor;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.internal.bridge.WikiBaseObjectComponentBuilder;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.internal.DefaultUntypedRecordableEventDescriptor;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.security.authorization.DocumentAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="XWiki.EventStream.Code.EventClass")
@Singleton
public class UntypedRecordableEventDescriptorComponentBuilder
implements WikiBaseObjectComponentBuilder {
    public static final String BOUNDED_XOBJECT_CLASS = "XWiki.EventStream.Code.EventClass";
    @Inject
    private DocumentAuthorizationManager authorizationManager;
    @Inject
    private ContextualLocalizationManager contextualLocalizationManager;
    @Inject
    private NamespaceContextExecutor namespaceContextExecutor;
    @Inject
    private Logger logger;

    public EntityReference getClassReference() {
        return new LocalDocumentReference(Arrays.asList("XWiki", "EventStream", "Code"), "EventClass");
    }

    public List<WikiComponent> buildComponents(BaseObject baseObject) throws WikiComponentException {
        try {
            XWikiDocument parentDocument = baseObject.getOwnerDocument();
            this.checkRights(parentDocument.getDocumentReference(), parentDocument.getAuthorReference());
            return Arrays.asList(new DefaultUntypedRecordableEventDescriptor(baseObject.getReference(), parentDocument.getAuthorReference(), baseObject, this.contextualLocalizationManager, this.namespaceContextExecutor));
        }
        catch (Exception e) {
            throw new WikiComponentException(String.format("Unable to build the UntypedRecordableEvent wiki component for [%s].", baseObject), (Throwable)e);
        }
    }

    private void checkRights(DocumentReference documentReference, DocumentReference authorReference) throws EventStreamException {
        if (!this.authorizationManager.hasAccess(Right.ADMIN, EntityType.WIKI, authorReference, documentReference)) {
            throw new EventStreamException("Registering Untyped Events requires wiki administration rights.");
        }
    }
}

