/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.edit.internal;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentBuilder;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.edit.internal.EditorWikiComponent;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

@Component
@Named(value="editor")
@Singleton
public class EditorWikiComponentBuilder
implements WikiComponentBuilder {
    @Inject
    private Logger logger;
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> currentDocumentReferenceResolver;
    @Inject
    private Provider<EditorWikiComponent> editorWikiComponentProvider;

    public List<WikiComponent> buildComponents(DocumentReference reference) throws WikiComponentException {
        EditorWikiComponent editorWikiComponent = (EditorWikiComponent)((Object)this.editorWikiComponentProvider.get());
        editorWikiComponent.initialize(reference);
        return Collections.singletonList(editorWikiComponent);
    }

    public List<DocumentReference> getDocumentReferences() {
        ArrayList<DocumentReference> editorReferences = new ArrayList<DocumentReference>();
        try {
            Query query = this.queryManager.createQuery(", BaseObject as editorObject, StringProperty as roleHint where doc.fullName = editorObject.name and editorObject.className = 'XWiki.EditorClass' and editorObject.id = roleHint.id.id and roleHint.id.name='roleHint' and (roleHint.value <> '' or (roleHint.value is not null and '' is null))", "hql");
            for (Object result : query.execute()) {
                editorReferences.add(this.currentDocumentReferenceResolver.resolve((Object)result.toString(), new Object[0]));
            }
        }
        catch (QueryException e) {
            this.logger.warn("Failed to query the editors defined in wiki pages. Root cause: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return editorReferences;
    }
}

