/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.edit.internal;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.edit.EditConfiguration;
import org.xwiki.edit.EditorConfiguration;

@Component
@Singleton
public class DefaultEditConfiguration
implements EditConfiguration {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    @Named(value="editorBindings/all")
    private ConfigurationSource allEditorBindingsSource;
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource xwikiPropertiesSource;

    @Override
    public String getDefaultEditor(Type dataType) {
        return this.getDefaultEditor(dataType, null);
    }

    @Override
    public String getDefaultEditor(Type dataType, String category) {
        EditorConfiguration<Type> customConfig;
        String defaultEditor;
        Object dataTypeName = dataType.getTypeName();
        if (!StringUtils.isEmpty((CharSequence)category)) {
            dataTypeName = (String)dataTypeName + "#" + category;
        }
        if (StringUtils.isEmpty((CharSequence)(defaultEditor = this.getDefaultEditor((String)dataTypeName))) && (customConfig = this.getCustomConfiguration(dataType)) != null) {
            defaultEditor = customConfig.getDefaultEditor(category);
        }
        return defaultEditor;
    }

    private <D extends Type> EditorConfiguration<D> getCustomConfiguration(D dataType) {
        DefaultParameterizedType customConfigType = new DefaultParameterizedType(null, EditorConfiguration.class, new Type[]{dataType});
        try {
            return (EditorConfiguration)((ComponentManager)this.componentManagerProvider.get()).getInstance((Type)customConfigType);
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }

    private String getDefaultEditor(String dataType) {
        String defaultEditor = (String)this.allEditorBindingsSource.getProperty(dataType, String.class);
        if (StringUtils.isEmpty((CharSequence)defaultEditor)) {
            defaultEditor = (String)this.xwikiPropertiesSource.getProperty("edit.defaultEditor." + dataType, String.class);
        }
        return defaultEditor;
    }
}

