/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.display.html.internal;

import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.script.ScriptContext;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.displayer.HTMLDisplayer;
import org.xwiki.displayer.HTMLDisplayerException;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.template.Template;
import org.xwiki.template.TemplateManager;

@Component
@Singleton
public class DefaultTemplateHTMLDisplayer
implements HTMLDisplayer<Object> {
    public static final String TEMPLATE_FOLDER = "html_displayer";
    public static final String DISPLAYER_VELOCITY_NAME = "displayer";
    public static final String TEMPLATE_EXTENSION = ".vm";
    @Inject
    protected TemplateManager templateManager;
    @Inject
    protected ScriptContextManager scriptContextManager;

    public String display(Type type, Object value) throws HTMLDisplayerException {
        return this.display(type, value, Collections.emptyMap());
    }

    public String display(Type type, Object value, Map<String, String> parameters) throws HTMLDisplayerException {
        return this.display(type, value, parameters, "view");
    }

    public String display(Type type, Object value, Map<String, String> parameters, String mode) throws HTMLDisplayerException {
        ScriptContext scriptContext = this.scriptContextManager.getCurrentScriptContext();
        try {
            HashMap<String, Object> displayer = new HashMap<String, Object>();
            displayer.put("type", type);
            displayer.put("value", value);
            displayer.put("parameters", parameters);
            displayer.put("mode", mode);
            scriptContext.setAttribute(DISPLAYER_VELOCITY_NAME, displayer, 100);
            StringWriter writer = new StringWriter();
            this.templateManager.render(this.getTemplate(type, value, mode), (Writer)writer);
            String string = ((Object)writer).toString();
            return string;
        }
        catch (Exception e) {
            throw new HTMLDisplayerException("Couldn't render the template", (Throwable)e);
        }
        finally {
            scriptContext.removeAttribute(DISPLAYER_VELOCITY_NAME, 100);
        }
    }

    private Template getTemplate(Type type, Object value, String mode) {
        if (type != null || value == null) {
            return this.getTemplate(type, mode);
        }
        return this.getTemplate(value.getClass(), mode);
    }

    private Template getTemplate(Type type, String mode) {
        String path;
        Template template = null;
        Iterator<String> iterator = this.getTemplatePaths(type, mode).iterator();
        while (iterator.hasNext() && (template = this.templateManager.getTemplate("html_displayer/" + (path = iterator.next()) + TEMPLATE_EXTENSION)) == null) {
        }
        return template;
    }

    private String cleanPath(String path) {
        return path.replaceAll("<", "(").replaceAll(">", ")").replaceAll("\\?", "_").replaceAll(" ", "");
    }

    private List<String> getTemplatePaths(Type type, String mode) {
        ArrayList<String> paths = new ArrayList<String>();
        for (String typeName : this.getTypeNames(type)) {
            if (mode != null) {
                paths.add(this.cleanPath(typeName + "/" + mode));
            }
            paths.add(this.cleanPath(typeName));
        }
        if (mode != null) {
            paths.add(this.cleanPath(mode));
        }
        paths.add("default");
        return paths;
    }

    private List<String> getTypeNames(Type type) {
        ArrayList<String> typeNames = new ArrayList<String>();
        if (type instanceof Class) {
            Class aClass = (Class)type;
            typeNames.add(aClass.getSimpleName().toLowerCase());
            if (aClass.isEnum()) {
                typeNames.add("enum");
            }
        } else if (type != null) {
            typeNames.add(ReflectionUtils.serializeType((Type)type).toLowerCase());
        }
        return typeNames;
    }
}

