/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.display.internal;

import java.util.ArrayDeque;
import java.util.Deque;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.model.reference.DocumentReference;

@Component(roles={DocumentReferenceDequeContext.class})
@Singleton
public class DocumentReferenceDequeContext {
    private static final String DOCUMENT_REFERENCE_STACK_KEY = "internal.displayer.%s.documentReferenceStack";
    @Inject
    private Execution execution;

    public Deque<DocumentReference> getDocumentReferenceDeque(String displayerName) {
        ExecutionContext econtext = this.execution.getContext();
        String contextKey = DOCUMENT_REFERENCE_STACK_KEY.formatted(displayerName);
        ArrayDeque documentReferenceStack = (ArrayDeque)econtext.getProperty(contextKey);
        if (documentReferenceStack == null) {
            documentReferenceStack = new ArrayDeque();
            econtext.newProperty(contextKey).inherited().initial(documentReferenceStack).makeFinal().declare();
        }
        return documentReferenceStack;
    }
}

