/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.display.internal;

import java.util.Arrays;
import java.util.Deque;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.display.internal.DocumentContentAsyncRenderer;
import org.xwiki.display.internal.DocumentDisplayer;
import org.xwiki.display.internal.DocumentDisplayerParameters;
import org.xwiki.display.internal.DocumentReferenceDequeContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.rendering.async.internal.AsyncRendererConfiguration;
import org.xwiki.rendering.async.internal.block.BlockAsyncRenderer;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererExecutor;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;

@Component
@Named(value="content")
@Singleton
public class DocumentContentDisplayer
implements DocumentDisplayer {
    private static final int INCLUSION_LIMIT = 5;
    @Inject
    private Provider<DocumentContentAsyncRenderer> rendererProvider;
    @Inject
    private BlockAsyncRendererExecutor executor;
    @Inject
    private DocumentReferenceDequeContext documentReferenceDequeContext;
    @Inject
    private Logger logger;

    @Override
    public XDOM display(DocumentModelBridge document, DocumentDisplayerParameters parameters) {
        Deque<DocumentReference> documentDeque = this.documentReferenceDequeContext.getDocumentReferenceDeque("content");
        if (DocumentContentDisplayer.countMatchingReferences(document, documentDeque) >= 5L) {
            this.logger.warn("Infinite recursion of document content detected in [{}].", (Object)document.getDocumentReference());
            throw new RuntimeException("Infinite document inclusion detected.");
        }
        documentDeque.push(document.getDocumentReference());
        try {
            DocumentContentAsyncRenderer renderer = (DocumentContentAsyncRenderer)((Object)this.rendererProvider.get());
            Set<String> contextEntries = renderer.initialize(document, parameters);
            AsyncRendererConfiguration configuration = new AsyncRendererConfiguration();
            configuration.setContextEntries(contextEntries);
            Block block = this.executor.execute((BlockAsyncRenderer)renderer, configuration);
            XDOM xDOM = block instanceof XDOM ? (XDOM)block : new XDOM(Arrays.asList(block));
            return xDOM;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            documentDeque.pop();
        }
    }

    private static long countMatchingReferences(DocumentModelBridge document, Deque<DocumentReference> documentDeque) {
        DocumentReference documentReference = document.getDocumentReference();
        return documentDeque.stream().filter(ref -> ref.equals((Object)documentReference)).count();
    }
}

