/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.display.internal;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.context.Execution;
import org.xwiki.display.internal.DocumentDisplayerParameters;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.RenderingException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.HeaderBlock;
import org.xwiki.rendering.block.ImageBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.block.match.CompositeBlockMatcher;
import org.xwiki.rendering.parser.ContentParser;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationManager;
import org.xwiki.rendering.util.IdGenerator;
import org.xwiki.velocity.VelocityManager;

@Component(roles={DocumentContentAsyncExecutor.class})
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DocumentContentAsyncExecutor {
    private static final String IS_IN_RENDERING_ENGINE = "isInRenderingEngine";
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    @Inject
    private Execution execution;
    @Inject
    private VelocityManager velocityManager;
    @Inject
    private ModelContext modelContext;
    @Inject
    private ContentParser parser;
    @Inject
    private TransformationManager transformationManager;
    @Inject
    private Logger logger;
    private DocumentDisplayerParameters parameters;
    private XDOM xdom;
    private DocumentReference documentReference;
    private DocumentModelBridge document;
    private Syntax syntax;
    private String transformationId;

    public void initialize(String transformationId, DocumentModelBridge document, DocumentDisplayerParameters parameters) {
        this.parameters = parameters;
        this.transformationId = transformationId;
        this.xdom = this.getPreparedContent(document, parameters);
        this.documentReference = document.getDocumentReference();
        this.syntax = document.getSyntax();
        this.document = document;
    }

    private XDOM getPreparedContent(DocumentModelBridge document, DocumentDisplayerParameters parameters) {
        IdGenerator idGenerator;
        XDOM content;
        XDOM xDOM = content = parameters.isContentTranslated() ? this.getPreparedTranslatedContent(document) : document.getPreparedXDOM();
        if (parameters.getSectionId() != null) {
            HeaderBlock headerBlock = (HeaderBlock)content.getFirstBlock((BlockMatcher)new CompositeBlockMatcher(new BlockMatcher[]{new ClassBlockMatcher(HeaderBlock.class), block -> ((HeaderBlock)block).getId().equals(parameters.getSectionId())}), Block.Axes.DESCENDANT);
            if (headerBlock == null) {
                throw new RuntimeException("Cannot find section [" + parameters.getSectionId() + "] in document [" + (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)document.getDocumentReference(), new Object[0]) + "]");
            }
            content = new XDOM(headerBlock.getSection().getChildren(), content.getMetaData());
        }
        if ((idGenerator = parameters.getIdGenerator()) != null) {
            content.setIdGenerator(idGenerator);
            this.makeIdsUnique(content, idGenerator);
        }
        return content;
    }

    private void makeIdsUnique(XDOM content, IdGenerator idGenerator) {
        content.getBlocks(block -> {
            if (block instanceof ImageBlock) {
                ImageBlock imageBlock = (ImageBlock)block;
                imageBlock.setId(this.adaptId(idGenerator, imageBlock.getId()));
            } else if (block instanceof HeaderBlock) {
                HeaderBlock headerBlock = (HeaderBlock)block;
                headerBlock.setId(this.adaptId(idGenerator, headerBlock.getId()));
            }
            return false;
        }, Block.Axes.DESCENDANT);
    }

    private String adaptId(IdGenerator idGenerator, String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            String prefix = id.substring(0, 1);
            String suffix = id.substring(1);
            return idGenerator.generateUniqueId(prefix, suffix);
        }
        return id;
    }

    private XDOM getPreparedTranslatedContent(DocumentModelBridge document) {
        try {
            DocumentModelBridge translatedDocument = this.documentAccessBridge.getTranslatedDocumentInstance(document);
            if (!document.getRealLanguage().equals(translatedDocument.getRealLanguage())) {
                if (document.getSyntax().equals((Object)translatedDocument.getSyntax())) {
                    return translatedDocument.getPreparedXDOM();
                }
                return this.parseContent(translatedDocument.getContent(), document.getSyntax(), document.getDocumentReference());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return document.getPreparedXDOM();
    }

    private XDOM parseContent(String content, Syntax syntax, DocumentReference source) {
        try {
            return this.parser.parse(content, syntax, (EntityReference)source);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XDOM execute(boolean async) throws RenderingException {
        Map<Object, Object> xwikiContext = this.getXWikiContextMap();
        Object isInRenderingEngine = xwikiContext.put(IS_IN_RENDERING_ENGINE, true);
        this.maybeOpenNameSpace(isInRenderingEngine);
        try {
            if (this.parameters.isExecutionContextIsolated()) {
                this.executeInIsolatedExecutionContext(async);
            } else {
                this.executeInCurrentExecutionContext(async);
            }
        }
        finally {
            this.maybeCloseNameSpace(isInRenderingEngine);
            if (isInRenderingEngine != null) {
                xwikiContext.put(IS_IN_RENDERING_ENGINE, isInRenderingEngine);
            } else {
                xwikiContext.remove(IS_IN_RENDERING_ENGINE);
            }
        }
        return this.xdom;
    }

    private Map<Object, Object> getXWikiContextMap() {
        return (Map)this.execution.getContext().getProperty("xwikicontext");
    }

    private void maybeOpenNameSpace(Object isInRenderingEngine) {
        if (this.parameters.isTransformationContextIsolated() && (isInRenderingEngine == null || isInRenderingEngine == Boolean.FALSE)) {
            try {
                this.velocityManager.getVelocityEngine().startedUsingMacroNamespace(this.transformationId);
                this.logger.debug("Started using velocity macro namespace [{}].", (Object)this.transformationId);
            }
            catch (Exception e) {
                this.logger.warn("Failed to notify Velocity Macro cache for opening the [{}] namespace. Reason = [{}]", (Object)this.transformationId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }

    private void maybeCloseNameSpace(Object isInRenderingEngine) {
        if (this.parameters.isTransformationContextIsolated() && (isInRenderingEngine == null || isInRenderingEngine == Boolean.FALSE)) {
            try {
                this.velocityManager.getVelocityEngine().stoppedUsingMacroNamespace(this.transformationId);
                this.logger.debug("Stopped using velocity macro namespace [{}].", (Object)this.transformationId);
            }
            catch (Exception e) {
                this.logger.warn("Failed to notify Velocity Macro cache for closing the [{}] namespace. Reason = [{}]", (Object)this.transformationId, (Object)e.getMessage());
            }
        }
    }

    private void executeInIsolatedExecutionContext(boolean async) throws RenderingException {
        HashMap backupObjects = new HashMap();
        EntityReference currentWikiReference = this.modelContext.getCurrentEntityReference();
        try {
            if (async || this.document == null) {
                this.documentAccessBridge.pushDocumentInContext(backupObjects, this.documentReference);
            } else {
                this.documentAccessBridge.pushDocumentInContext(backupObjects, this.document);
            }
            this.modelContext.setCurrentEntityReference((EntityReference)this.documentReference.getWikiReference());
            this.executeInCurrentExecutionContext(async);
        }
        catch (Exception e) {
            throw new RenderingException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.documentAccessBridge.popDocumentFromContext(backupObjects);
            this.modelContext.setCurrentEntityReference(currentWikiReference);
        }
    }

    private void executeInCurrentExecutionContext(boolean async) throws RenderingException {
        if (!async && !this.parameters.isContentTransformed()) {
            return;
        }
        this.xdom.getMetaData().addMetaData("base", this.defaultEntityReferenceSerializer.serialize((EntityReference)this.documentAccessBridge.getCurrentDocumentReference(), new Object[0]));
        TransformationContext txContext = new TransformationContext(this.xdom, this.syntax, this.parameters.isTransformationContextRestricted());
        txContext.setId(this.transformationId);
        txContext.setTargetSyntax(this.parameters.getTargetSyntax());
        this.transformationManager.performTransformations((Block)this.xdom, txContext);
    }
}

