/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.xml.internal;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.util.Timeout;
import org.xwiki.component.annotation.Component;
import org.xwiki.diff.xml.XMLDiffDataURIConverterConfiguration;

@Component(roles={HttpClientBuilderFactory.class})
@Singleton
public class HttpClientBuilderFactory {
    @Inject
    private XMLDiffDataURIConverterConfiguration configuration;

    public HttpClientBuilder create() {
        HttpClientBuilder result = HttpClientBuilder.create();
        result.useSystemProperties();
        result.setUserAgent("XWikiHTMLDiff");
        Timeout timeout = Timeout.ofSeconds((long)this.configuration.getHTTPTimeout());
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout).build();
        BasicHttpClientConnectionManager cm = new BasicHttpClientConnectionManager();
        cm.setConnectionConfig(connectionConfig);
        result.setConnectionManager((HttpClientConnectionManager)cm);
        result.setDefaultRequestConfig(RequestConfig.custom().setResponseTimeout(timeout).build());
        return result;
    }
}

