/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.dashboard;

import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.platform.security.requiredrights.RequiredRight;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.RequiredRightsException;
import org.xwiki.platform.security.requiredrights.display.BlockSupplierProvider;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.parser.ContentParser;
import org.xwiki.rendering.parser.MissingParserException;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.velocity.internal.util.VelocityDetector;

@Component
@Singleton
@Named(value="XWiki.GadgetClass")
public class GadgetObjectRequiredRightAnalyzer
implements RequiredRightAnalyzer<BaseObject> {
    @Inject
    @Named(value="translation")
    private BlockSupplierProvider<String> translationMessageSupplierProvider;
    @Inject
    private VelocityDetector velocityDetector;
    @Inject
    private ContentParser contentParser;
    @Inject
    private RequiredRightAnalyzer<XDOM> xdomRequiredRightAnalyzer;

    public List<RequiredRightAnalysisResult> analyze(BaseObject object) throws RequiredRightsException {
        String contentString;
        ArrayList<RequiredRightAnalysisResult> result = new ArrayList<RequiredRightAnalysisResult>();
        String titleString = object.getStringValue("title");
        if (titleString != null && this.velocityDetector.containsVelocityScript(titleString)) {
            result.add(new RequiredRightAnalysisResult(object.getReference(), this.translationMessageSupplierProvider.get((Object)"dashboard.requiredrights.gadget.title", new Object[0]), this.translationMessageSupplierProvider.get((Object)"dashboard.requiredrights.gadget.title.description", new Object[]{titleString}), List.of(RequiredRight.MAYBE_SCRIPT, RequiredRight.MAYBE_PROGRAM)));
        }
        if ((contentString = object.getStringValue("content")) != null) {
            try {
                XDOM parsedContent = this.contentParser.parse(contentString, object.getOwnerDocument().getSyntax(), (EntityReference)object.getDocumentReference());
                parsedContent.getMetaData().addMetaData("entityReference", (Object)object.getReference());
                result.addAll(this.xdomRequiredRightAnalyzer.analyze((Object)parsedContent));
            }
            catch (MissingParserException | ParseException e) {
                throw new RequiredRightsException("Failed to parse value of 'content' property.", e);
            }
        }
        return result;
    }
}

