/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.dashboard;

import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.internal.macro.dashboard.XDOMChecker;

@Component
@Named(value="empty")
@Singleton
public class EmptyXDOMChecker
implements XDOMChecker {
    @Override
    public boolean check(List<Block> blocks) {
        return this.isContentEmpty(blocks);
    }

    private boolean isContentEmpty(List<Block> blocks) {
        boolean result = false;
        if (blocks.isEmpty()) {
            result = true;
        } else {
            result = true;
            for (Block block : blocks) {
                if (this.isMacroMarkerBlockAndEmpty(block)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private boolean isMacroMarkerBlockAndEmpty(Block block) {
        return block instanceof MacroMarkerBlock && block.getChildren().isEmpty();
    }
}

