/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.dashboard;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.internal.macro.dashboard.DefaultGadgetRenderer;
import org.xwiki.rendering.macro.dashboard.Gadget;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.RenderingContext;

@Component
@Named(value="edit")
@Singleton
public class EditableGadgetRenderer
extends DefaultGadgetRenderer {
    protected static final String METADATA = "metadata";
    private static final String ANNOTATED_SYNTAXES_PREFIX = "annotated";
    @Inject
    @Named(value="annotatedxhtml/1.0")
    protected BlockRenderer defaultGadgetContentRenderer;
    @Inject
    protected ComponentManager componentManager;
    @Inject
    protected RenderingContext renderingContext;
    @Inject
    protected Logger logger;

    protected BlockRenderer getGadgetContentRenderer() {
        Syntax currentTargetSyntax = this.renderingContext.getTargetSyntax();
        if (currentTargetSyntax == null) {
            return this.defaultGadgetContentRenderer;
        }
        Object annotatedTargetSyntax = currentTargetSyntax.toIdString();
        if (!Strings.CS.startsWith((CharSequence)annotatedTargetSyntax, (CharSequence)ANNOTATED_SYNTAXES_PREFIX)) {
            annotatedTargetSyntax = ANNOTATED_SYNTAXES_PREFIX + (String)annotatedTargetSyntax;
        }
        try {
            return (BlockRenderer)this.componentManager.getInstance(BlockRenderer.class, (String)annotatedTargetSyntax);
        }
        catch (ComponentLookupException e) {
            this.logger.warn("Failed to load the syntax [{}].", annotatedTargetSyntax);
            return this.defaultGadgetContentRenderer;
        }
    }

    protected Syntax getRawBlockSyntax(BlockRenderer gadgetContentRenderer) {
        return gadgetContentRenderer != this.defaultGadgetContentRenderer ? this.renderingContext.getTargetSyntax() : Syntax.XHTML_1_0;
    }

    protected Block getGadgetEditMetadata(Gadget gadget) {
        GroupBlock metadataBlock = new GroupBlock();
        metadataBlock.setParameter("class", METADATA);
        boolean isMacro = gadget.getContent().size() == 1 && gadget.getContent().get(0) instanceof MacroMarkerBlock;
        GroupBlock isMacroBlock = new GroupBlock();
        isMacroBlock.setParameter("class", "isMacro");
        isMacroBlock.addChild((Block)new WordBlock(Boolean.toString(isMacro)));
        metadataBlock.addChild((Block)isMacroBlock);
        if (isMacro) {
            GroupBlock renderedContentBlock = new GroupBlock();
            renderedContentBlock.setParameter("class", "content");
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            BlockRenderer gadgetContentRenderer = this.getGadgetContentRenderer();
            gadgetContentRenderer.render(gadget.getContent(), (WikiPrinter)printer);
            RawBlock rawBlock = new RawBlock(printer.toString(), this.getRawBlockSyntax(gadgetContentRenderer));
            renderedContentBlock.addChild((Block)rawBlock);
            GroupBlock gadgetTitleBlock = new GroupBlock();
            gadgetTitleBlock.setParameter("class", "title");
            gadgetTitleBlock.addChild((Block)new WordBlock(gadget.getTitleSource()));
            metadataBlock.addChild((Block)renderedContentBlock);
            metadataBlock.addChild((Block)gadgetTitleBlock);
        }
        return metadataBlock;
    }

    @Override
    public List<Block> decorateGadget(Gadget gadget) {
        List<Block> viewBlock = super.decorateGadget(gadget);
        if (viewBlock.size() > 0) {
            viewBlock.get(0).addChild(this.getGadgetEditMetadata(gadget));
        }
        return viewBlock;
    }
}

