/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.csrf.internal;

import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.container.Container;
import org.xwiki.container.Request;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.container.servlet.filters.SavedRequestManager;
import org.xwiki.csrf.CSRFToken;
import org.xwiki.csrf.CSRFTokenConfiguration;
import org.xwiki.model.reference.DocumentReference;

@Component
@Singleton
public class DefaultCSRFToken
implements CSRFToken,
Initializable {
    private static final int TOKEN_LENGTH = 16;
    private static final String RESUBMIT_TEMPLATE = "resubmit";
    private final ConcurrentMap<DocumentReference, String> tokens = new ConcurrentHashMap<DocumentReference, String>();
    private String guestToken;
    private SecureRandom random;
    @Inject
    private DocumentAccessBridge docBridge;
    @Inject
    private Container container;
    @Inject
    private CSRFTokenConfiguration configuration;
    @Inject
    private Logger logger;

    public void initialize() throws InitializationException {
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            this.random = new SecureRandom();
            this.logger.warn("Using default implementation of SecureRandom for CSRF token");
        }
        byte[] seed = this.random.generateSeed(16);
        this.random.setSeed(seed);
        this.logger.debug("Anti-CSRF secret token component has been initialized");
    }

    protected void setRandom(SecureRandom random) {
        this.random = random;
    }

    @Override
    public String getToken() {
        DocumentReference key = this.getTokenKey();
        if (key == null) {
            if (this.guestToken == null) {
                this.guestToken = this.newToken();
            }
            return this.guestToken;
        }
        return this.tokens.computeIfAbsent(key, documentReference -> this.newToken());
    }

    private String newToken() {
        byte[] bytes = new byte[16];
        this.random.nextBytes(bytes);
        return Base64.encodeBase64URLSafeString((byte[])bytes).replaceAll("[_=+-]", "x");
    }

    @Override
    public void clearToken() {
        this.logger.debug("Forgetting CSRF token for [{}]", (Object)this.getTokenKey());
        this.tokens.remove(this.getTokenKey());
    }

    @Override
    public boolean isTokenValid(String token) {
        if (!this.configuration.isEnabled()) {
            return true;
        }
        String storedToken = this.getToken();
        if (token == null || token.isEmpty() || !storedToken.equals(token)) {
            this.logger.warn("Secret CSRF token verification failed (token: [{}], stored token: [{}])", (Object)token, (Object)storedToken);
            return false;
        }
        return true;
    }

    @Override
    public String getResubmissionURL() {
        String query = "resubmit=" + this.urlEncode(this.getRequestURI());
        String backUrl = this.getDocumentURL(this.docBridge.getCurrentDocumentReference(), null);
        query = query + "&xback=" + this.urlEncode(backUrl);
        query = query + "&xpage=resubmit";
        return backUrl + "?" + query;
    }

    @Override
    public String getRequestURI() {
        String srid = SavedRequestManager.saveRequest((HttpServletRequest)this.getRequest());
        Object resubmitUrl = this.getRequest().getRequestURI();
        resubmitUrl = (String)resubmitUrl + "?" + SavedRequestManager.getSavedRequestIdentifier() + "=" + srid;
        return resubmitUrl;
    }

    private String getDocumentURL(DocumentReference reference, String query) {
        return this.docBridge.getDocumentURL(reference, "view", query, null);
    }

    private String urlEncode(String str) {
        String encoding = "UTF-8";
        try {
            return URLEncoder.encode(str, encoding);
        }
        catch (UnsupportedEncodingException exception) {
            return "";
        }
    }

    private HttpServletRequest getRequest() {
        Request request = this.container.getRequest();
        if (request instanceof ServletRequest) {
            ServletRequest servletRequest = (ServletRequest)request;
            return servletRequest.getRequest();
        }
        throw new RuntimeException("Not supported request type");
    }

    private DocumentReference getTokenKey() {
        return this.docBridge.getCurrentUserReference();
    }
}

