/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.store.wiki.internal.query;

import java.util.ArrayList;
import java.util.Collection;
import org.xwiki.crypto.BinaryStringEncoder;
import org.xwiki.crypto.pkix.CertificateFactory;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.PrincipalIndentifier;
import org.xwiki.crypto.store.CertificateStoreException;
import org.xwiki.crypto.store.wiki.internal.query.AbstractX509SubjectQuery;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.query.QueryManager;

public class X509CertificateSubjectQuery
extends AbstractX509SubjectQuery {
    private static final String SELECT_STATEMENT = "select obj.certificate";
    private static final String FROM_STATEMENT = ", doc.object(Crypto.CertificateClass) obj";
    private final CertificateFactory factory;

    public X509CertificateSubjectQuery(EntityReference store, CertificateFactory factory, BinaryStringEncoder encoder, QueryManager queryManager, EntityReferenceSerializer<String> serializer) throws CertificateStoreException {
        super(store, SELECT_STATEMENT, FROM_STATEMENT, "", encoder, queryManager, serializer);
        this.factory = factory;
    }

    public Collection<CertifiedPublicKey> getCertificates(PrincipalIndentifier subject) {
        ArrayList<CertifiedPublicKey> result = new ArrayList<CertifiedPublicKey>();
        try {
            for (String cert : this.execute(subject)) {
                try {
                    result.add(this.factory.decode(this.getEncoder().decode(cert)));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

