/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.store.wiki.internal.query;

import java.io.IOException;
import java.util.List;
import org.xwiki.crypto.BinaryStringEncoder;
import org.xwiki.crypto.store.CertificateStoreException;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

public abstract class AbstractX509StoreQuery {
    private static final String FROM_STATEMENT = " from Document doc";
    private static final String WHERE_STATEMENT = " where 1=1";
    private static final String STORE = "store";
    private static final String WHERE_SPACE_STATEMENT = " where doc.space=:store";
    private static final String WHERE_DOC_STATEMENT = " where doc.fullName=:store";
    private final BinaryStringEncoder encoder;
    private Query query;

    public AbstractX509StoreQuery(EntityReference store, String select, String from, String where, BinaryStringEncoder encoder, QueryManager queryManager, EntityReferenceSerializer<String> serializer) throws CertificateStoreException {
        EntityReference wiki = null;
        EntityType storeType = null;
        if (store != null) {
            wiki = store.extractReference(EntityType.WIKI);
            storeType = this.getEntityType(store);
        }
        if (wiki == null || storeType == null) {
            throw new IllegalArgumentException("Certificate could only be queried from wiki, space, or document.");
        }
        this.encoder = encoder;
        String statement = select + FROM_STATEMENT + from;
        statement = storeType != EntityType.WIKI ? (storeType == EntityType.DOCUMENT ? statement + WHERE_DOC_STATEMENT : statement + WHERE_SPACE_STATEMENT) : statement + WHERE_STATEMENT;
        statement = statement + where;
        try {
            this.query = queryManager.createQuery(statement, "xwql");
        }
        catch (QueryException e) {
            throw new CertificateStoreException((Throwable)e);
        }
        this.query.setWiki(wiki.getName());
        if (storeType != EntityType.WIKI) {
            this.query.bindValue(STORE, serializer.serialize(store, new Object[0]));
        }
    }

    private EntityType getEntityType(EntityReference store) {
        if (store.getType() == EntityType.DOCUMENT && store.getParent() != null) {
            return EntityType.DOCUMENT;
        }
        if (store.getType() == EntityType.SPACE) {
            return EntityType.SPACE;
        }
        if (store.getType() == EntityType.WIKI) {
            return EntityType.WIKI;
        }
        return null;
    }

    protected Query getQuery() {
        return this.query;
    }

    protected BinaryStringEncoder getEncoder() {
        return this.encoder;
    }

    protected <T> List<T> execute() throws IOException, QueryException {
        return this.getQuery().execute();
    }
}

