/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.store.wiki.internal.query;

import java.math.BigInteger;
import java.util.List;
import org.xwiki.crypto.BinaryStringEncoder;
import org.xwiki.crypto.pkix.params.PrincipalIndentifier;
import org.xwiki.crypto.store.CertificateStoreException;
import org.xwiki.crypto.store.wiki.internal.query.AbstractX509StoreQuery;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

public abstract class AbstractX509IssuerAndSerialQuery
extends AbstractX509StoreQuery {
    private static final String ISSUER = "issuer";
    private static final String SERIAL = "serial";
    private static final String AND_OBJ = " and obj.";
    private static final String EQUAL = "=:";
    private static final String WHERE_STATEMENT = " and obj.issuer=:issuer and obj.serial=:serial";

    public AbstractX509IssuerAndSerialQuery(EntityReference store, String select, String from, String where, BinaryStringEncoder encoder, QueryManager queryManager, EntityReferenceSerializer<String> serializer) throws CertificateStoreException {
        super(store, select, from, WHERE_STATEMENT + where, encoder, queryManager, serializer);
    }

    protected <T> List<T> execute(PrincipalIndentifier issuer, BigInteger serial) throws QueryException {
        return this.getQuery().bindValue(ISSUER, (Object)issuer.getName()).bindValue(SERIAL, (Object)serial.toString()).execute();
    }
}

