/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.store.wiki.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.AsymmetricKeyFactory;
import org.xwiki.crypto.password.PrivateKeyPasswordBasedEncryptor;
import org.xwiki.crypto.pkix.params.CertifiedKeyPair;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.x509certificate.X509CertifiedPublicKey;
import org.xwiki.crypto.store.CertificateStoreException;
import org.xwiki.crypto.store.KeyStore;
import org.xwiki.crypto.store.KeyStoreException;
import org.xwiki.crypto.store.StoreReference;
import org.xwiki.crypto.store.wiki.internal.AbstractX509WikiStore;
import org.xwiki.crypto.store.wiki.internal.X509CertificateWikiStore;
import org.xwiki.crypto.store.wiki.internal.query.CertificateObjectReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;

@Component
@Named(value="X509wiki")
@Singleton
public class X509KeyWikiStore
extends AbstractX509WikiStore
implements KeyStore {
    public static final String PRIVATEKEYCLASS_SPACE = "Crypto";
    public static final String PRIVATEKEYCLASS_NAME = "PrivateKeyClass";
    public static final String PRIVATEKEYCLASS_FULLNAME = "Crypto.PrivateKeyClass";
    public static final LocalDocumentReference PRIVATEKEYCLASS = new LocalDocumentReference("Crypto", "PrivateKeyClass");
    public static final String PRIVATEKEYCLASS_PROP_KEY = "key";
    @Inject
    private PrivateKeyPasswordBasedEncryptor encryptor;
    @Inject
    private AsymmetricKeyFactory keyFactory;

    public void store(StoreReference store, CertifiedKeyPair keyPair) throws KeyStoreException {
        this.storeKeyPair(store, keyPair.getCertificate(), keyPair.getPrivateKey().getEncoded());
    }

    public void store(StoreReference store, CertifiedKeyPair keyPair, byte[] password) throws KeyStoreException {
        byte[] key;
        try {
            key = this.encryptor.encrypt(password, keyPair.getPrivateKey());
        }
        catch (Exception e) {
            throw new KeyStoreException("Error while encrypting private key to store a key pair in [" + String.valueOf(store) + "]", (Throwable)e);
        }
        this.storeKeyPair(store, keyPair.getCertificate(), key);
    }

    private void storeKeyPair(StoreReference store, CertifiedPublicKey certificate, byte[] privateKey) throws KeyStoreException {
        XWikiDocument document;
        XWikiContext context = this.getXWikiContext();
        try {
            document = this.storeCertificate(store, certificate, context);
        }
        catch (CertificateStoreException e) {
            throw new KeyStoreException("Error while preparing certificate to store a key pair in [" + String.valueOf(store) + "]", (Throwable)e);
        }
        try {
            BaseObject obj = document.getXObject((EntityReference)PRIVATEKEYCLASS);
            if (obj == null) {
                obj = document.newXObject((EntityReference)PRIVATEKEYCLASS, context);
            }
            obj.setLargeStringValue(PRIVATEKEYCLASS_PROP_KEY, this.getEncoder().encode(privateKey, 64));
            context.getWiki().saveDocument(document, context);
        }
        catch (IOException e) {
            throw new KeyStoreException("Error while preparing private key for [" + String.valueOf(document.getDocumentReference()) + "]", (Throwable)e);
        }
        catch (XWikiException e) {
            throw new KeyStoreException("Error while saving key pair for [" + String.valueOf(document.getDocumentReference()) + "]", (Throwable)e);
        }
    }

    public CertifiedKeyPair retrieve(StoreReference store) throws KeyStoreException {
        return this.retrieve(store, (byte[])null);
    }

    public CertifiedKeyPair retrieve(StoreReference store, byte[] password) throws KeyStoreException {
        XWikiContext context = this.getXWikiContext();
        try {
            XWikiDocument document = context.getWiki().getDocument(this.getDocumentReference(store), context);
            BaseObject certObj = document.getXObject((EntityReference)X509CertificateWikiStore.CERTIFICATECLASS);
            BaseObject pkObj = document.getXObject((EntityReference)PRIVATEKEYCLASS);
            if (pkObj == null || certObj == null) {
                return null;
            }
            byte[] cert = this.getEncoder().decode(certObj.getLargeStringValue("certificate"));
            byte[] key = this.getEncoder().decode(pkObj.getLargeStringValue(PRIVATEKEYCLASS_PROP_KEY));
            if (password != null) {
                return new CertifiedKeyPair(this.encryptor.decrypt(password, key), this.getCertificateFactory().decode(cert));
            }
            return new CertifiedKeyPair(this.keyFactory.fromPKCS8(key), this.getCertificateFactory().decode(cert));
        }
        catch (Exception e) {
            throw new KeyStoreException("Failed to retrieved private key from [" + String.valueOf(store) + "]");
        }
    }

    public CertifiedKeyPair retrieve(StoreReference store, CertifiedPublicKey publicKey) throws KeyStoreException {
        return this.retrieve(store, publicKey, null);
    }

    public CertifiedKeyPair retrieve(StoreReference store, CertifiedPublicKey certificate, byte[] password) throws KeyStoreException {
        if (!(certificate instanceof X509CertifiedPublicKey)) {
            throw new IllegalArgumentException("Certificate should be X509 certificates.");
        }
        X509CertifiedPublicKey publicKey = (X509CertifiedPublicKey)certificate;
        XWikiContext context = this.getXWikiContext();
        try {
            CertificateObjectReference certRef = this.findCertificate(store, publicKey);
            if (certRef == null) {
                return null;
            }
            XWikiDocument document = this.getDocument(store, certRef, context);
            BaseObject pkObj = document.getXObject((EntityReference)PRIVATEKEYCLASS);
            if (pkObj == null) {
                return null;
            }
            byte[] key = this.getEncoder().decode(pkObj.getLargeStringValue(PRIVATEKEYCLASS_PROP_KEY));
            if (password != null) {
                return new CertifiedKeyPair(this.encryptor.decrypt(password, key), certificate);
            }
            return new CertifiedKeyPair(this.keyFactory.fromPKCS8(key), certificate);
        }
        catch (Exception e) {
            throw new KeyStoreException("Failed to retrieved private key for certificate [" + publicKey.getSubject().getName() + "]");
        }
    }
}

