/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.store.wiki.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import java.util.Collection;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.pkix.CertificateProvider;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.store.CertificateStore;
import org.xwiki.crypto.store.CertificateStoreException;
import org.xwiki.crypto.store.StoreReference;
import org.xwiki.crypto.store.wiki.internal.AbstractX509WikiStore;
import org.xwiki.crypto.store.wiki.internal.X509CertificateProvider;
import org.xwiki.crypto.store.wiki.internal.query.X509CertificateQuery;
import org.xwiki.model.reference.LocalDocumentReference;

@Component
@Named(value="X509wiki")
@Singleton
public class X509CertificateWikiStore
extends AbstractX509WikiStore
implements CertificateStore {
    public static final String CERTIFICATECLASS_SPACE = "Crypto";
    public static final String CERTIFICATECLASS_NAME = "CertificateClass";
    public static final String CERTIFICATECLASS_FULLNAME = "Crypto.CertificateClass";
    public static final LocalDocumentReference CERTIFICATECLASS = new LocalDocumentReference("Crypto", "CertificateClass");
    public static final String CERTIFICATECLASS_PROP_ISSUER = "issuer";
    public static final String CERTIFICATECLASS_PROP_SERIAL = "serial";
    public static final String CERTIFICATECLASS_PROP_SUBJECT = "subject";
    public static final String CERTIFICATECLASS_PROP_KEYID = "keyid";
    public static final String CERTIFICATECLASS_PROP_CERTIFICATE = "certificate";

    public void store(StoreReference store, CertifiedPublicKey certificate) throws CertificateStoreException {
        XWikiContext context = this.getXWikiContext();
        try {
            context.getWiki().saveDocument(this.storeCertificate(store, certificate, context), context);
        }
        catch (XWikiException e) {
            throw new CertificateStoreException("Error while saving certificate to store [" + String.valueOf(store) + "]", (Throwable)e);
        }
    }

    public CertificateProvider getCertificateProvider(StoreReference store) throws CertificateStoreException {
        return new X509CertificateProvider(this.resolveStore(store), this.getCertificateFactory(), this.getEncoder(), this.getQueryManager(), this.getSerializer());
    }

    public Collection<CertifiedPublicKey> getAllCertificates(StoreReference store) throws CertificateStoreException {
        return new X509CertificateQuery(this.resolveStore(store), this.getCertificateFactory(), this.getEncoder(), this.getQueryManager(), this.getSerializer()).getCertificates();
    }
}

