/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.store.wiki.internal;

import java.math.BigInteger;
import java.util.Collection;
import org.xwiki.crypto.BinaryStringEncoder;
import org.xwiki.crypto.pkix.CertificateFactory;
import org.xwiki.crypto.pkix.CertificateProvider;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.PrincipalIndentifier;
import org.xwiki.crypto.store.CertificateStoreException;
import org.xwiki.crypto.store.wiki.internal.query.X509CertificateIssuerAndSerialQuery;
import org.xwiki.crypto.store.wiki.internal.query.X509CertificateKeyIdentifierQuery;
import org.xwiki.crypto.store.wiki.internal.query.X509CertificateSubjectQuery;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.query.QueryManager;

public class X509CertificateProvider
implements CertificateProvider {
    private final X509CertificateKeyIdentifierQuery keyIdentifierQuery;
    private final X509CertificateIssuerAndSerialQuery issuerAndSerialQuery;
    private final X509CertificateSubjectQuery subjectQuery;

    protected X509CertificateProvider(EntityReference store, CertificateFactory factory, BinaryStringEncoder encoder, QueryManager queryManager, EntityReferenceSerializer<String> serializer) throws CertificateStoreException {
        this.keyIdentifierQuery = new X509CertificateKeyIdentifierQuery(store, factory, encoder, queryManager, serializer);
        this.issuerAndSerialQuery = new X509CertificateIssuerAndSerialQuery(store, factory, encoder, queryManager, serializer);
        this.subjectQuery = new X509CertificateSubjectQuery(store, factory, encoder, queryManager, serializer);
    }

    public CertifiedPublicKey getCertificate(byte[] keyIdentifier) {
        return this.keyIdentifierQuery.getCertificate(keyIdentifier);
    }

    public CertifiedPublicKey getCertificate(PrincipalIndentifier issuer, BigInteger serial) {
        return this.issuerAndSerialQuery.getCertificate(issuer, serial);
    }

    public CertifiedPublicKey getCertificate(PrincipalIndentifier issuer, BigInteger serial, byte[] keyIdentifier) {
        CertifiedPublicKey certificate = this.getCertificate(keyIdentifier);
        if (certificate == null) {
            certificate = this.getCertificate(issuer, serial);
        }
        return certificate;
    }

    public Collection<CertifiedPublicKey> getCertificate(PrincipalIndentifier subject) {
        return this.subjectQuery.getCertificates(subject);
    }
}

