/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.store.wiki.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.crypto.BinaryStringEncoder;
import org.xwiki.crypto.pkix.CertificateFactory;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.x509certificate.X509CertifiedPublicKey;
import org.xwiki.crypto.store.CertificateStoreException;
import org.xwiki.crypto.store.StoreReference;
import org.xwiki.crypto.store.WikiStoreReference;
import org.xwiki.crypto.store.wiki.internal.X509CertificateWikiStore;
import org.xwiki.crypto.store.wiki.internal.query.CertificateObjectReference;
import org.xwiki.crypto.store.wiki.internal.query.X509CertificateReferenceIssuerAndSerialQuery;
import org.xwiki.crypto.store.wiki.internal.query.X509CertificateReferenceKeyIdentifierQuery;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.query.QueryManager;

public abstract class AbstractX509WikiStore {
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    @Named(value="current")
    private EntityReferenceResolver<EntityReference> referenceResolver;
    @Inject
    @Named(value="current")
    private EntityReferenceResolver<String> stringReferenceResolver;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    @Named(value="Base64")
    private BinaryStringEncoder base64;
    @Inject
    @Named(value="X509")
    private CertificateFactory certificateFactory;
    @Inject
    private QueryManager queryManager;

    protected XWikiContext getXWikiContext() {
        return (XWikiContext)this.contextProvider.get();
    }

    protected BinaryStringEncoder getEncoder() {
        return this.base64;
    }

    protected CertificateFactory getCertificateFactory() {
        return this.certificateFactory;
    }

    protected QueryManager getQueryManager() {
        return this.queryManager;
    }

    protected EntityReferenceSerializer<String> getSerializer() {
        return this.entityReferenceSerializer;
    }

    protected XWikiDocument storeCertificate(StoreReference store, CertifiedPublicKey certificate, XWikiContext context) throws CertificateStoreException {
        if (!(certificate instanceof X509CertifiedPublicKey)) {
            throw new IllegalArgumentException("Certificate should be X509 certificates.");
        }
        X509CertifiedPublicKey publicKey = (X509CertifiedPublicKey)certificate;
        try {
            BaseObject obj;
            XWikiDocument document;
            CertificateObjectReference certRef = this.findCertificate(store, publicKey);
            if (certRef != null) {
                document = this.getDocument(store, certRef, context);
                obj = document.getXObject((EntityReference)X509CertificateWikiStore.CERTIFICATECLASS, certRef.getObjectNumber());
            } else {
                document = context.getWiki().getDocument(this.getDocumentReference(store, publicKey), context);
                obj = document.newXObject((EntityReference)X509CertificateWikiStore.CERTIFICATECLASS, context);
                byte[] keyId = publicKey.getSubjectKeyIdentifier();
                if (keyId != null) {
                    obj.setStringValue("keyid", this.base64.encode(keyId));
                }
                obj.setStringValue("issuer", publicKey.getIssuer().getName());
                obj.setStringValue("serial", publicKey.getSerialNumber().toString());
                obj.setStringValue("subject", publicKey.getSubject().getName());
            }
            obj.setLargeStringValue("certificate", this.base64.encode(certificate.getEncoded(), 64));
            return document;
        }
        catch (Exception e) {
            throw new CertificateStoreException("Error while preparing certificate for store [" + String.valueOf(store) + "]", (Throwable)e);
        }
    }

    protected CertificateObjectReference findCertificate(StoreReference store, X509CertifiedPublicKey publicKey) throws CertificateStoreException {
        byte[] keyId = publicKey.getSubjectKeyIdentifier();
        CertificateObjectReference certRef = keyId != null ? new X509CertificateReferenceKeyIdentifierQuery(this.resolveStore(store), this.base64, this.queryManager, this.entityReferenceSerializer).getReference(keyId) : new X509CertificateReferenceIssuerAndSerialQuery(this.resolveStore(store), this.base64, this.queryManager, this.entityReferenceSerializer).getReference(publicKey.getIssuer(), publicKey.getSerialNumber());
        return certRef;
    }

    protected XWikiDocument getDocument(StoreReference store, CertificateObjectReference certRef, XWikiContext context) throws XWikiException {
        XWikiDocument document = context.getWiki().getDocument(new DocumentReference(this.stringReferenceResolver.resolve((Object)certRef.getDocumentName(), EntityType.DOCUMENT, new Object[]{store})), context);
        return document;
    }

    protected DocumentReference getDocumentReference(StoreReference store) {
        return new DocumentReference(this.referenceResolver.resolve((Object)this.getStoreReference(store), EntityType.DOCUMENT, new Object[0]));
    }

    protected DocumentReference getDocumentReference(StoreReference store, X509CertifiedPublicKey publicKey) throws Exception {
        EntityReference reference = this.getStoreReference(store);
        if (reference.getType() == EntityType.DOCUMENT) {
            return this.getDocumentReference(store);
        }
        return new DocumentReference(this.referenceResolver.resolve((Object)new EntityReference(this.getCertIdentifier(publicKey), EntityType.DOCUMENT), EntityType.DOCUMENT, new Object[]{reference}));
    }

    private String getCertIdentifier(X509CertifiedPublicKey publicKey) throws Exception {
        byte[] keyId = publicKey.getSubjectKeyIdentifier();
        if (keyId != null) {
            return this.base64.encode(keyId);
        }
        return publicKey.getSerialNumber().toString() + ", " + publicKey.getIssuer().getName();
    }

    protected EntityReference resolveStore(StoreReference store) {
        EntityReference reference = this.getStoreReference(store);
        if (reference.getType() == EntityType.DOCUMENT) {
            return this.referenceResolver.resolve((Object)reference, EntityType.DOCUMENT, new Object[0]);
        }
        return this.referenceResolver.resolve((Object)reference, EntityType.SPACE, new Object[0]);
    }

    private EntityReference getStoreReference(StoreReference store) {
        if (store instanceof WikiStoreReference) {
            return ((WikiStoreReference)store).getReference();
        }
        throw new IllegalArgumentException("Unsupported store reference [" + store.getClass().getName() + "] for this implementation.");
    }
}

