/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.container.servlet.internal;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.container.servlet.events.HttpSessionCreatedEvent;
import org.xwiki.container.servlet.events.HttpSessionDestroyedEvent;
import org.xwiki.container.servlet.events.SessionCreatedEvent;
import org.xwiki.container.servlet.events.SessionDestroyedEvent;
import org.xwiki.jakartabridge.servlet.JakartaServletBridge;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@Component(roles={HttpSessionManager.class})
@Singleton
public class HttpSessionManager
implements Initializable,
Disposable,
HttpSessionListener {
    @Inject
    private ObservationManager observationManager;
    private ConcurrentLinkedQueue<HttpSession> sessionsList;

    public void initialize() throws InitializationException {
        this.sessionsList = new ConcurrentLinkedQueue();
    }

    public void dispose() throws ComponentLifecycleException {
        for (HttpSession httpSession : this.sessionsList) {
            if (httpSession.isNew()) continue;
            httpSession.invalidate();
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        this.sessionsList.add(session);
        this.observationManager.notify((Event)new HttpSessionCreatedEvent(), (Object)session, null);
        this.observationManager.notify((Event)new SessionCreatedEvent(), (Object)JakartaServletBridge.toJavax((HttpSession)session), null);
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        this.sessionsList.remove(session);
        this.observationManager.notify((Event)new HttpSessionDestroyedEvent(), (Object)session, null);
        this.observationManager.notify((Event)new SessionDestroyedEvent(), (Object)JakartaServletBridge.toJavax((HttpSession)session), null);
    }

    protected List<HttpSession> getSessionList() {
        return new ArrayList<HttpSession>(this.sessionsList);
    }
}

