/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.container.servlet.filters.internal;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.container.servlet.HttpServletUtils;

public class ResolveRelativeRedirectFilter
implements Filter {
    private boolean resolveRedirect = true;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object filteredResponse = response;
        if (this.resolveRedirect && filteredResponse instanceof HttpServletResponse) {
            HttpServletResponse httpResponse = (HttpServletResponse)filteredResponse;
            filteredResponse = new ResolveRelativeRedirectResponse((HttpServletRequest)request, httpResponse);
        }
        chain.doFilter(request, filteredResponse);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ComponentManager rootComponentManager = (ComponentManager)filterConfig.getServletContext().getAttribute(ComponentManager.class.getName());
        try {
            ConfigurationSource properties = (ConfigurationSource)rootComponentManager.getInstance(ConfigurationSource.class, "xwikiproperties");
            this.resolveRedirect = (Boolean)properties.getProperty("container.request.resolveRelativeRedirect", (Object)true);
        }
        catch (ComponentLookupException e) {
            throw new ServletException("Failed to access configuration", (Throwable)e);
        }
    }

    public class ResolveRelativeRedirectResponse
    extends HttpServletResponseWrapper {
        private final HttpServletRequest request;
        private URI sourceURI;

        public ResolveRelativeRedirectResponse(HttpServletRequest request, HttpServletResponse response) throws MalformedURLException {
            super(response);
            this.request = request;
        }

        public URI getSourceURI() {
            if (this.sourceURI == null) {
                try {
                    this.sourceURI = HttpServletUtils.getSourceURL(this.request).toURI();
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    // empty catch block
                }
            }
            return this.sourceURI;
        }

        public void sendRedirect(String location) throws IOException {
            String url = location;
            if (StringUtils.isNotBlank((CharSequence)location)) {
                try {
                    URI referenceURI;
                    URI locationURI = new URI(location);
                    if (!locationURI.isAbsolute() && (referenceURI = this.getSourceURI()) != null) {
                        url = referenceURI.resolve(location).toString();
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            super.sendRedirect(url);
        }
    }
}

