/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.container.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.embed.EmbeddableComponentManager;
import org.xwiki.component.internal.StackingComponentEventManager;
import org.xwiki.component.manager.ComponentEventManager;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.container.ApplicationContextListenerManager;
import org.xwiki.container.Container;
import org.xwiki.container.servlet.ServletContainerInitializer;
import org.xwiki.container.servlet.internal.HttpSessionManager;
import org.xwiki.environment.Environment;
import org.xwiki.environment.internal.ServletEnvironment;
import org.xwiki.extension.handler.ExtensionInitializer;
import org.xwiki.jakartabridge.servlet.JakartaServletBridge;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.ApplicationStartedEvent;
import org.xwiki.observation.event.ApplicationStoppedEvent;
import org.xwiki.observation.event.Event;

public class XWikiServletContextListener
implements ServletContextListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiServletContextListener.class);
    private static final String TOMCAT_CATALINA = "Catalina";
    private static final Logger SHUTDOWN_LOGGER = LoggerFactory.getLogger((String)"org.xwiki.shutdown");
    private EmbeddableComponentManager componentManager;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ObservationManager observationManager;
        EmbeddableComponentManager ecm = new EmbeddableComponentManager();
        ecm.initialize(this.getClass().getClassLoader());
        this.componentManager = ecm;
        servletContextEvent.getServletContext().setAttribute(ComponentManager.class.getName(), (Object)this.componentManager);
        StackingComponentEventManager eventManager = new StackingComponentEventManager();
        this.componentManager.setComponentEventManager((ComponentEventManager)eventManager);
        try {
            ServletEnvironment servletEnvironment = (ServletEnvironment)this.componentManager.getInstance(Environment.class);
            servletEnvironment.setServletContext(servletContextEvent.getServletContext());
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Failed to initialize the Servlet Environment", e);
        }
        try {
            ServletContainerInitializer containerInitializer = (ServletContainerInitializer)this.componentManager.getInstance(ServletContainerInitializer.class);
            containerInitializer.initializeApplicationContext(JakartaServletBridge.toJavax((ServletContext)servletContextEvent.getServletContext()));
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Failed to initialize the Application Context", e);
        }
        try {
            observationManager = (ObservationManager)this.componentManager.getInstance(ObservationManager.class);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Failed to find the Observation Manager component", e);
        }
        try {
            this.componentManager.getInstance(ExtensionInitializer.class);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Failed to initialize installed extensions", e);
        }
        try {
            HttpSessionManager httpSessionManager = (HttpSessionManager)this.componentManager.getInstance(HttpSessionManager.class);
            servletContextEvent.getServletContext().addListener((EventListener)((Object)httpSessionManager));
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Failed to initialize HttpSessionManager", e);
        }
        eventManager.setObservationManager(observationManager);
        eventManager.shouldStack(false);
        eventManager.flushEvents();
        this.allowAllURLCharacters(servletContextEvent.getServletContext());
        observationManager.notify((Event)new ApplicationStartedEvent(), (Object)this);
    }

    private void allowAllURLCharacters(ServletContext servletContext) {
        if (this.isForceAllowAnyCharacter()) {
            this.allowAllURLCharactersTomcat();
            this.allowAllURLCharactersJetty(servletContext);
        }
    }

    private boolean isForceAllowAnyCharacter() {
        try {
            ConfigurationSource configuration = (ConfigurationSource)this.componentManager.getInstance(ConfigurationSource.class, "xwikiproperties");
            return (Boolean)configuration.getProperty("url.forceAllowAnyCharacter", (Object)true);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Failed to access the configuration", e);
        }
    }

    private void allowAllURLCharactersTomcat() {
        try {
            ArrayList<MBeanServer> mbeanServers = MBeanServerFactory.findMBeanServer(null);
            if (!mbeanServers.isEmpty()) {
                MBeanServer mBeanServer = mbeanServers.get(0);
                ObjectName name = new ObjectName(TOMCAT_CATALINA, "type", "Server");
                Object server = mBeanServer.getAttribute(name, "managedResource");
                Object service = MethodUtils.invokeMethod((Object)server, (String)"findService", (Object[])new Object[]{TOMCAT_CATALINA});
                Object connectors = MethodUtils.invokeMethod((Object)service, (String)"findConnectors");
                for (int i = 0; i < Array.getLength(connectors); ++i) {
                    Object connector = Array.get(connectors, i);
                    MethodUtils.invokeMethod((Object)connector, (String)"setAllowBackslash", (Object[])new Object[]{true});
                    MethodUtils.invokeMethod((Object)connector, (String)"setEncodedSolidusHandling", (Object[])new Object[]{"passthrough"});
                    MethodUtils.invokeMethod((Object)connector, (String)"setRejectSuspiciousURIs", (Object[])new Object[]{false});
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Failed to configure Tomcat URL constraints", (Throwable)e);
        }
    }

    private void allowAllURLCharactersJetty(ServletContext servletContext) {
        try {
            Object contextHandler = MethodUtils.invokeMethod((Object)servletContext, (String)"getContextHandler");
            Object servletHandler = MethodUtils.invokeMethod((Object)contextHandler, (String)"getServletHandler");
            MethodUtils.invokeMethod((Object)servletHandler, (String)"setDecodeAmbiguousURIs", (Object[])new Object[]{true});
            Object server = MethodUtils.invokeMethod((Object)contextHandler, (String)"getServer");
            Object connectors = MethodUtils.invokeMethod((Object)server, (String)"getConnectors");
            Object uriCompliance = null;
            for (int i = 0; i < Array.getLength(connectors); ++i) {
                uriCompliance = this.configureConnectorJetty(Array.get(connectors, i), uriCompliance);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Failed to configure Jetty URL constraints", (Throwable)e);
        }
    }

    private Object configureConnectorJetty(Object connector, Object inputUriCompliance) {
        Object uriCompliance = inputUriCompliance;
        try {
            Object factories = MethodUtils.invokeMethod((Object)connector, (String)"getConnectionFactories");
            if (factories instanceof Collection) {
                Collection factoriesCollection = (Collection)factories;
                for (Object factory : factoriesCollection) {
                    uriCompliance = this.configureFactoryJetty(factory, uriCompliance);
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Failed to get factories", (Throwable)e);
        }
        return uriCompliance;
    }

    private Object configureFactoryJetty(Object factory, Object inputUriCompliance) {
        Object uriCompliance = inputUriCompliance;
        try {
            Object httpConfiguration = MethodUtils.invokeMethod((Object)factory, (String)"getHttpConfiguration");
            if (uriCompliance == null) {
                uriCompliance = this.getUriCompliance(httpConfiguration);
            }
            MethodUtils.invokeMethod((Object)httpConfiguration, (String)"setUriCompliance", (Object[])new Object[]{uriCompliance});
            MethodUtils.invokeMethod((Object)httpConfiguration, (String)"setRedirectUriCompliance", (Object[])new Object[]{uriCompliance});
        }
        catch (Exception e) {
            LOGGER.debug("Failed to set the URI compliance", (Throwable)e);
        }
        return uriCompliance;
    }

    private Object getUriCompliance(Object httpConfiguration) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> uriComplianceClass = MethodUtils.invokeMethod((Object)httpConfiguration, (String)"getUriCompliance").getClass();
        Class violationsClass = this.getViolationClass(uriComplianceClass);
        HashSet<Object> violations = new HashSet<Object>();
        violations.add(Enum.valueOf(violationsClass, "AMBIGUOUS_PATH_SEGMENT"));
        violations.add(Enum.valueOf(violationsClass, "AMBIGUOUS_EMPTY_SEGMENT"));
        violations.add(Enum.valueOf(violationsClass, "AMBIGUOUS_PATH_SEPARATOR"));
        violations.add(Enum.valueOf(violationsClass, "AMBIGUOUS_PATH_PARAMETER"));
        violations.add(Enum.valueOf(violationsClass, "AMBIGUOUS_PATH_ENCODING"));
        violations.add(Enum.valueOf(violationsClass, "SUSPICIOUS_PATH_CHARACTERS"));
        Enum fragmentViolation = EnumUtils.getEnum((Class)violationsClass, (String)"FRAGMENT");
        if (fragmentViolation != null) {
            violations.add(fragmentViolation);
        }
        return ConstructorUtils.invokeConstructor(uriComplianceClass, (Object[])new Object[]{"XWiki", violations});
    }

    private Class getViolationClass(Class<?> uriComplianceClass) {
        for (Class<?> innerClass : uriComplianceClass.getDeclaredClasses()) {
            boolean isViolationClass = innerClass.getName().equals("org.eclipse.jetty.http.UriCompliance$Violation");
            if (!isViolationClass) continue;
            return innerClass;
        }
        return null;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        SHUTDOWN_LOGGER.debug("Stopping XWiki...");
        if (this.componentManager != null) {
            try {
                ObservationManager observationManager = (ObservationManager)this.componentManager.getInstance(ObservationManager.class);
                observationManager.notify((Event)new ApplicationStoppedEvent(), (Object)this);
            }
            catch (ComponentLookupException observationManager) {
                // empty catch block
            }
            try {
                ApplicationContextListenerManager applicationContextListenerManager = (ApplicationContextListenerManager)this.componentManager.getInstance(ApplicationContextListenerManager.class);
                Container container = (Container)this.componentManager.getInstance(Container.class);
                applicationContextListenerManager.destroyApplicationContext(container.getApplicationContext());
            }
            catch (ComponentLookupException componentLookupException) {
                // empty catch block
            }
            this.componentManager.dispose();
        }
        SHUTDOWN_LOGGER.debug("XWiki has been stopped!");
    }
}

