/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.container.servlet;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.http.HttpServletRequest;

public class SetThreadNameServletRequestListener
implements ServletRequestListener {
    private static final String ORIGINAL_THREAD_NAME_ATTRIBUTE = "xwiki.thread.originalName";

    public void requestInitialized(ServletRequestEvent sre) {
        ServletRequest servletRequest = sre.getServletRequest();
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            Object threadName = httpServletRequest.getRequestURL().toString();
            if (httpServletRequest.getQueryString() != null) {
                threadName = (String)threadName + "?" + httpServletRequest.getQueryString();
            }
            String originalThreadName = Thread.currentThread().getName();
            threadName = String.format("%s - %s", originalThreadName, threadName);
            httpServletRequest.setAttribute(ORIGINAL_THREAD_NAME_ATTRIBUTE, (Object)originalThreadName);
            Thread.currentThread().setName((String)threadName);
        }
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        ServletRequest servletRequest = sre.getServletRequest();
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            Thread.currentThread().setName(String.valueOf(httpServletRequest.getAttribute(ORIGINAL_THREAD_NAME_ATTRIBUTE)));
        }
    }
}

