/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.container.servlet;

import jakarta.servlet.http.HttpServletRequest;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HeaderElement;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.container.servlet.internal.ForwardedHeader;
import org.xwiki.jakartabridge.servlet.JakartaServletBridge;
import org.xwiki.stability.Unstable;

public final class HttpServletUtils {
    public static final String HEADER_FORWARDED = "forwarded";
    public static final String HEADER_X_FORWARDED_HOST = "x-forwarded-host";
    public static final String HEADER_X_FORWARDED_PROTO = "x-forwarded-proto";
    private static final String HEADER_CACHE_CONTROL = "Cache-Control";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpServletUtils.class);

    private HttpServletUtils() {
    }

    @Unstable
    public static URL getSourceURL(HttpServletRequest servletRequest) throws MalformedURLException {
        URL baseURL = HttpServletUtils.getSourceBaseURL(servletRequest);
        StringBuilder path = new StringBuilder();
        path.append(servletRequest.getRequestURI());
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{servletRequest.getQueryString()})) {
            path.append('?');
            path.append(servletRequest.getQueryString());
        }
        return new URL(baseURL, path.toString());
    }

    @Unstable
    public static URL getSourceBaseURL(HttpServletRequest servletRequest) throws MalformedURLException {
        StringBuilder builder = new StringBuilder();
        HttpServletUtils.appendScheme(servletRequest, builder);
        builder.append("://");
        HttpServletUtils.appendHostPort(servletRequest, builder);
        try {
            return new URL(builder.toString());
        }
        catch (MalformedURLException e) {
            return HttpServletUtils.getFinalBaseURL(servletRequest);
        }
    }

    private static URL getFinalBaseURL(HttpServletRequest servletRequest) throws MalformedURLException {
        return new URL(servletRequest.getScheme(), servletRequest.getRemoteHost(), servletRequest.getRemotePort(), "");
    }

    private static void appendScheme(HttpServletRequest request, StringBuilder builder) {
        ForwardedHeader forwardedHeader;
        String forwarded = request.getHeader(HEADER_FORWARDED);
        if (StringUtils.isNotEmpty((CharSequence)forwarded) && (forwardedHeader = new ForwardedHeader(forwarded)).getProto() != null) {
            builder.append(forwardedHeader.getProto());
            return;
        }
        String proxyProto = HttpServletUtils.getFirstHeaderValue(request, HEADER_X_FORWARDED_PROTO);
        if (proxyProto != null) {
            builder.append(proxyProto);
            return;
        }
        String scheme = request.getScheme();
        if (HTTP.equalsIgnoreCase(scheme) && request.isSecure()) {
            scheme = HTTPS;
        }
        builder.append(scheme != null ? scheme : HTTP);
    }

    private static void appendHostPort(HttpServletRequest request, StringBuilder builder) {
        ForwardedHeader forwardedHeader;
        String forwarded = request.getHeader(HEADER_FORWARDED);
        if (StringUtils.isNotEmpty((CharSequence)forwarded) && (forwardedHeader = new ForwardedHeader(forwarded)).getHost() != null) {
            builder.append(forwardedHeader.getHost());
            return;
        }
        String proxyHost = HttpServletUtils.getFirstHeaderValue(request, HEADER_X_FORWARDED_HOST);
        if (proxyHost != null) {
            builder.append(proxyHost);
            return;
        }
        StringBuffer buffer = request.getRequestURL();
        if (buffer != null && !buffer.isEmpty()) {
            String requestURLString = buffer.toString();
            try {
                URL requestURL = new URL(requestURLString);
                builder.append(requestURL.getHost());
                int port = requestURL.getPort();
                if (port != -1) {
                    builder.append(':');
                    builder.append(port);
                }
                return;
            }
            catch (MalformedURLException e) {
                LOGGER.error("The request URL indicated by the application server is wrong: {}", (Object)requestURLString, (Object)e);
            }
        }
        builder.append(request.getServerName());
        int port = request.getServerPort();
        if (port != -1) {
            builder.append(':');
            builder.append(port);
        }
    }

    private static String getFirstHeaderValue(HttpServletRequest request, String key) {
        String value = request.getHeader(key);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            int index = value.indexOf(44);
            if (index != -1) {
                value = value.substring(0, index);
            }
            if (StringUtils.isNotEmpty((CharSequence)(value = value.trim()))) {
                return value;
            }
        }
        return null;
    }

    @Unstable
    public static boolean isCacheReadAllowed(HttpServletRequest request) {
        String headerValue = request.getHeader(HEADER_CACHE_CONTROL);
        if (headerValue != null) {
            BasicHeader cacheControlHeader = new BasicHeader(HEADER_CACHE_CONTROL, headerValue);
            for (HeaderElement element : cacheControlHeader.getElements()) {
                if (!element.getName().equals("no-cache")) continue;
                return false;
            }
        }
        return true;
    }

    @Unstable
    public static Map<String, List<String>> getHeaders(HttpServletRequest request) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Enumeration eName = request.getHeaderNames();
        while (eName.hasMoreElements()) {
            String headerName = (String)eName.nextElement();
            List headerValues = map.computeIfAbsent(headerName, k -> new ArrayList());
            Enumeration eValue = request.getHeaders(headerName);
            while (eValue.hasMoreElements()) {
                headerValues.add((String)eValue.nextElement());
            }
        }
        return map;
    }

    @Unstable
    public static String getClientIP(HttpServletRequest request) {
        String remoteIP = request.getHeader("X-Forwarded-For");
        if (remoteIP == null || "".equals(remoteIP)) {
            remoteIP = request.getRemoteAddr();
        } else if (remoteIP.indexOf(44) != -1) {
            remoteIP = remoteIP.substring(0, remoteIP.indexOf(44));
        }
        return remoteIP;
    }

    @Deprecated(since="17.0.0RC1")
    public static URL getSourceURL(javax.servlet.http.HttpServletRequest servletRequest) {
        try {
            return HttpServletUtils.getSourceURL(JakartaServletBridge.toJakarta((javax.servlet.http.HttpServletRequest)servletRequest));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("XWiki received an invalid URL path or query string", e);
        }
    }

    @Deprecated(since="17.0.0RC1")
    public static URL getSourceBaseURL(javax.servlet.http.HttpServletRequest servletRequest) {
        try {
            return HttpServletUtils.getSourceBaseURL(JakartaServletBridge.toJakarta((javax.servlet.http.HttpServletRequest)servletRequest));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("XWiki received an invalid URL", e);
        }
    }

    @Deprecated(since="17.0.0RC1")
    public static boolean isCacheReadAllowed(javax.servlet.http.HttpServletRequest request) {
        return HttpServletUtils.isCacheReadAllowed(JakartaServletBridge.toJakarta((javax.servlet.http.HttpServletRequest)request));
    }
}

