/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.container.servlet;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;

public class HttpServletRequestStub
implements HttpServletRequest {
    private boolean secure;
    private String scheme;
    private String protocol;
    private String queryString;
    private String contextPath;
    private String servletPath;
    private String serverName;
    private int serverPort;
    private Map<String, List<String>> headers;
    private Map<String, String[]> parameters;
    private Cookie[] cookies;
    private List<Part> parts = new ArrayList<Part>();
    private String requestURI;
    private StringBuffer requestURL;
    private String remoteAddr;
    private boolean daemon = true;
    private HttpSession httpSession;

    public HttpServletRequestStub() {
    }

    protected HttpServletRequestStub(Builder builder) {
        if (builder.requestURL != null) {
            this.protocol = builder.requestURL.getProtocol();
            this.scheme = builder.requestURL.getProtocol();
            this.serverName = builder.requestURL.getHost();
            this.serverPort = builder.requestURL.getPort();
            this.secure = this.protocol.equalsIgnoreCase("https");
            this.requestURI = builder.requestURL.getPath();
            this.requestURL = new StringBuffer(builder.requestURL.toString());
            this.setHost(builder.requestURL.getHost());
        }
        this.contextPath = builder.contextPath;
        this.parameters = this.clone(builder.requestParameters);
        this.headers = this.cloneHeaders(builder.headers);
        this.cookies = this.clone(builder.cookies);
        this.remoteAddr = builder.remoteAddr;
        this.httpSession = builder.httpSession;
    }

    public HttpServletRequestStub(HttpServletRequest request) {
        this.secure = request.isSecure();
        this.protocol = request.getProtocol();
        this.scheme = request.getScheme();
        this.serverName = request.getServerName();
        this.serverPort = request.getServerPort();
        this.contextPath = request.getContextPath();
        this.servletPath = request.getServletPath();
        this.queryString = request.getQueryString();
        this.requestURI = request.getRequestURI();
        this.requestURL = new StringBuffer(request.getRequestURL());
        if (request.getHeaderNames() != null) {
            this.headers = Collections.list(request.getHeaderNames()).stream().map(headerName -> Map.entry(headerName, Collections.list(request.getHeaders(headerName)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (left, right) -> right, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER)));
        }
        this.parameters = this.clone(request.getParameterMap());
        this.cookies = this.clone(request.getCookies());
        this.remoteAddr = request.getRemoteAddr();
        try {
            this.setParts(request.getParts());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (request instanceof HttpServletRequestStub) {
            HttpServletRequestStub requestStub = (HttpServletRequestStub)request;
            this.setDaemon(requestStub.isDaemon());
        }
    }

    private Map<String, String[]> clone(Map<String, String[]> map) {
        LinkedHashMap<String, String[]> clone;
        if (map != null) {
            clone = new LinkedHashMap<String, String[]>(map.size());
            for (Map.Entry<String, String[]> entry : map.entrySet()) {
                clone.put(entry.getKey(), (String[])entry.getValue().clone());
            }
        } else {
            clone = null;
        }
        return clone;
    }

    private Map<String, List<String>> cloneHeaders(Map<String, List<String>> headers) {
        if (headers == null) {
            return null;
        }
        return headers.entrySet().stream().filter(entry -> entry.getValue() != null && !((List)entry.getValue()).isEmpty()).map(entry -> Map.entry((String)entry.getKey(), ((List)entry.getValue()).stream().collect(Collectors.toList()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (left, right) -> right, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER)));
    }

    private Cookie[] clone(Cookie[] cookies) {
        if (cookies != null) {
            return (Cookie[])Stream.of(cookies).map(Cookie::clone).toArray(Cookie[]::new);
        }
        return null;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setHost(String host) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, List<String>>();
        }
        this.headers.put("x-forwarded-host", new Vector<String>(Arrays.asList(host)));
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setrequestURL(StringBuffer requestURL) {
        this.requestURL = requestURL;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getHeader(String headerName) {
        List<String> values;
        if (this.headers != null && (values = this.headers.get(headerName)) != null && !values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    public void put(String key, String value) {
        Object[] values;
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, String[]>();
        }
        values = (values = this.parameters.get(key)) == null ? new String[]{value} : (String[])ArrayUtils.add((Object[])values, (Object)value);
        this.parameters.put(key, (String[])values);
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        return this.clone(this.cookies);
    }

    public long getDateHeader(String s) {
        return 0L;
    }

    public Enumeration<String> getHeaders(String headerName) {
        List<String> values;
        if (this.headers != null && (values = this.headers.get(headerName)) != null) {
            return Collections.enumeration(values);
        }
        return Collections.emptyEnumeration();
    }

    public Enumeration<String> getHeaderNames() {
        return this.headers != null ? Collections.enumeration(this.headers.keySet()) : Collections.emptyEnumeration();
    }

    public int getIntHeader(String s) {
        String header = this.getHeader(s);
        return header != null ? Integer.parseInt(header) : -1;
    }

    public String getMethod() {
        return null;
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteUser() {
        return null;
    }

    public boolean isUserInRole(String s) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        return this.requestURL == null ? new StringBuffer() : this.requestURL;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession(boolean b) {
        return this.httpSession;
    }

    public String changeSessionId() {
        return null;
    }

    public HttpSession getSession() {
        return this.httpSession;
    }

    public void setSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public Object getAttribute(String s) {
        return null;
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.emptyEnumeration();
    }

    public String getCharacterEncoding() {
        return null;
    }

    public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
    }

    public int getContentLength() {
        return 0;
    }

    public long getContentLengthLong() {
        return 0L;
    }

    public String getContentType() {
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public String getParameter(String s) {
        Object[] values;
        if (this.parameters != null && ArrayUtils.isNotEmpty((Object[])(values = this.parameters.get(s)))) {
            return values[0];
        }
        return null;
    }

    public Enumeration<String> getParameterNames() {
        return this.parameters != null ? Collections.enumeration(this.parameters.keySet()) : null;
    }

    public String[] getParameterValues(String s) {
        if (this.parameters != null) {
            String[] values = this.parameters.get(s);
            return values != null ? (String[])values.clone() : null;
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public Map<String, String[]> getParameterMap() {
        return this.clone(this.parameters);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return null;
    }

    public void setAttribute(String s, Object o) {
    }

    public void removeAttribute(String s) {
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration<Locale> getLocales() {
        return null;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return null;
    }

    @Deprecated
    public String getRealPath(String s) {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public String getLocalName() {
        return null;
    }

    public String getLocalAddr() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public boolean authenticate(HttpServletResponse httpServletResponse) throws IOException, ServletException {
        return false;
    }

    public void login(String s, String s1) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this.parts;
    }

    public Part getPart(String s) throws IOException, ServletException {
        return this.parts.stream().filter(part -> Objects.equals(part.getName(), s)).findFirst().orElse(null);
    }

    public void setParts(Collection<Part> parts) {
        this.parts = new ArrayList<Part>(parts);
    }

    public ServletContext getServletContext() {
        return null;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return null;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return null;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        return null;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public static class Builder {
        private URL requestURL;
        private String contextPath;
        private Map<String, String[]> requestParameters;
        private Map<String, List<String>> headers;
        private Cookie[] cookies;
        private String remoteAddr;
        private HttpSession httpSession;

        public Builder setRequestURL(URL requestURL) {
            this.requestURL = requestURL;
            return this;
        }

        public Builder setContextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public Builder setRequestParameters(Map<String, String[]> requestParameters) {
            this.requestParameters = requestParameters;
            return this;
        }

        public Builder setHeaders(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder setCookies(Cookie[] cookies) {
            this.cookies = cookies;
            return this;
        }

        public Builder setRemoteAddr(String remoteAddr) {
            this.remoteAddr = remoteAddr;
            return this;
        }

        public Builder setHttpSession(HttpSession httpSession) {
            this.httpSession = httpSession;
            return this;
        }

        public HttpServletRequestStub build() {
            return new HttpServletRequestStub(this);
        }
    }
}

