/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import org.apache.commons.configuration2.Configuration;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.configuration.ConversionException;
import org.xwiki.properties.ConverterManager;

public class CommonsConfigurationSource
implements ConfigurationSource {
    @Inject
    protected ConverterManager converterManager;
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Configuration configuration;

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public <T> T getProperty(String key, T defaultValue) {
        if (this.containsKey(key)) {
            if (defaultValue != null) {
                return (T)this.getProperty(key, defaultValue.getClass());
            }
            return this.getProperty(key);
        }
        T result = defaultValue;
        return result;
    }

    public <T> T getProperty(String key) {
        this.lock.readLock().lock();
        try {
            Object object = this.getConfiguration().getProperty(key);
            return (T)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public <T> T getProperty(String key, Class<T> valueClass) {
        Object result = null;
        try {
            if (String.class == valueClass) {
                result = this.getString(key);
            } else if (List.class.isAssignableFrom(valueClass)) {
                result = this.getList(key);
            } else if (Properties.class.isAssignableFrom(valueClass)) {
                result = this.getProperties(key);
            } else {
                T value = this.getProperty(key);
                if (value != null) {
                    result = this.converterManager.convert(valueClass, value);
                }
            }
        }
        catch (org.apache.commons.configuration2.ex.ConversionException | org.xwiki.properties.converter.ConversionException e) {
            throw new ConversionException("Key [" + key + "] is not compatible with type [" + valueClass.getName() + "]", e);
        }
        return (T)result;
    }

    private String getString(String key) {
        this.lock.readLock().lock();
        try {
            String string = this.getConfiguration().getString(key);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private List<Object> getList(String key) {
        this.lock.readLock().lock();
        try {
            List list = this.getConfiguration().getList(key);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Properties getProperties(String key) {
        this.lock.readLock().lock();
        try {
            Properties properties = this.getConfiguration().getProperties(key);
            return properties;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getKeys() {
        this.lock.readLock().lock();
        try {
            ArrayList<String> keysList = new ArrayList<String>();
            Iterator keys = this.getConfiguration().getKeys();
            while (keys.hasNext()) {
                keysList.add((String)keys.next());
            }
            ArrayList<String> arrayList = keysList;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean containsKey(String key) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.getConfiguration().containsKey(key);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.getConfiguration().isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

