/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import com.xpn.xwiki.XWikiContext;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.configuration.internal.AbstractDocumentConfigurationSource;
import org.xwiki.configuration.internal.CompositeConfigurationSource;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.LocalDocumentReference;

public abstract class AbstractWikisConfigurationSource
extends AbstractDocumentConfigurationSource {
    protected abstract LocalDocumentReference getLocalDocumentReference();

    @Override
    protected DocumentReference getDocumentReference() {
        return new DocumentReference(this.getLocalDocumentReference(), this.getCurrentWikiReference());
    }

    @Override
    public boolean containsKey(String key) {
        return this.getConfigurationSource().containsKey(key);
    }

    @Override
    public List<String> getKeys() {
        return this.getConfigurationSource().getKeys();
    }

    @Override
    public <T> T getProperty(String key) {
        return (T)this.getConfigurationSource().getProperty(key);
    }

    @Override
    public <T> T getProperty(String key, T defaultValue) {
        return (T)this.getConfigurationSource().getProperty(key, defaultValue);
    }

    @Override
    public <T> T getProperty(String key, Class<T> valueClass) {
        return (T)this.getConfigurationSource().getProperty(key, valueClass);
    }

    @Override
    public boolean isEmpty() {
        return this.getConfigurationSource().isEmpty();
    }

    private ConfigurationSource getConfigurationSource() {
        CompositeConfigurationSource compositeConfigSource = new CompositeConfigurationSource();
        this.getWikis().stream().map(x$0 -> new WikiConfigurationSource((String)x$0)).forEachOrdered(wikiConfigSource -> compositeConfigSource.addConfigurationSource((ConfigurationSource)wikiConfigSource));
        return compositeConfigSource;
    }

    protected List<String> getWikis() {
        LinkedHashSet<String> wikis = new LinkedHashSet<String>();
        wikis.add(this.wikiManager.getCurrentWikiId());
        wikis.add(this.wikiManager.getMainWikiId());
        return wikis.stream().collect(Collectors.toList());
    }

    private class WikiConfigurationSource
    implements ConfigurationSource {
        private final String wiki;

        WikiConfigurationSource(String wiki) {
            this.wiki = wiki;
        }

        public boolean containsKey(String key) {
            return this.getFromWiki(() -> AbstractWikisConfigurationSource.super.containsKey(key));
        }

        public List<String> getKeys() {
            return this.getFromWiki(() -> AbstractWikisConfigurationSource.super.getKeys());
        }

        public <T> T getProperty(String key) {
            return (T)this.getFromWiki(() -> AbstractWikisConfigurationSource.super.getProperty(key));
        }

        public <T> T getProperty(String key, T defaultValue) {
            return (T)this.getFromWiki(() -> AbstractWikisConfigurationSource.super.getProperty(key, defaultValue));
        }

        public <T> T getProperty(String key, Class<T> valueClass) {
            return (T)this.getFromWiki(() -> AbstractWikisConfigurationSource.super.getProperty(key, valueClass));
        }

        public boolean isEmpty() {
            return this.getFromWiki(() -> AbstractWikisConfigurationSource.super.isEmpty());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T getFromWiki(Supplier<T> supplier) {
            XWikiContext xcontext = (XWikiContext)AbstractWikisConfigurationSource.this.xcontextProvider.get();
            String currentWiki = xcontext.getWikiId();
            try {
                xcontext.setWikiId(this.wiki);
                T t = supplier.get();
                return t;
            }
            finally {
                xcontext.setWikiId(currentWiki);
            }
        }
    }
}

