/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.configuration.internal.AbstractConfigurationSource;

public abstract class AbstractCompositeConfigurationSource
extends AbstractConfigurationSource
implements Iterable<ConfigurationSource> {
    public boolean containsKey(String key) {
        boolean result = false;
        for (ConfigurationSource source : this) {
            if (!source.containsKey(key)) continue;
            result = true;
            break;
        }
        return result;
    }

    public <T> T getProperty(String key) {
        Object result = null;
        for (ConfigurationSource source : this) {
            if (!source.containsKey(key)) continue;
            result = source.getProperty(key);
            break;
        }
        return (T)result;
    }

    public <T> T getProperty(String key, Class<T> valueClass) {
        Object result = null;
        for (ConfigurationSource source : this) {
            if (!source.containsKey(key)) continue;
            result = source.getProperty(key, valueClass);
            break;
        }
        if (result == null) {
            result = this.getDefault(valueClass);
        }
        return (T)result;
    }

    public <T> T getProperty(String key, T defaultValue) {
        Object result = null;
        for (ConfigurationSource source : this) {
            if (!source.containsKey(key)) continue;
            result = source.getProperty(key, defaultValue);
            break;
        }
        if (result == null) {
            result = defaultValue;
        }
        return (T)result;
    }

    public List<String> getKeys() {
        LinkedHashSet keys = new LinkedHashSet();
        for (ConfigurationSource source : this) {
            keys.addAll(source.getKeys());
        }
        return new ArrayList<String>(keys);
    }

    public boolean isEmpty() {
        boolean result = true;
        for (ConfigurationSource source : this) {
            if (source.isEmpty()) continue;
            result = false;
            break;
        }
        return result;
    }
}

