/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.wiki.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.cache.CacheControl;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.internal.AbstractAsyncBaseObjectWikiComponent;
import org.xwiki.component.wiki.internal.bridge.ContentParser;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererExecutor;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.Transformation;

public abstract class AbstractAsyncContentBaseObjectWikiComponent
extends AbstractAsyncBaseObjectWikiComponent {
    @Inject
    protected ContentParser parser;
    @Inject
    protected ComponentManager componentManager;
    @Inject
    protected BlockAsyncRendererExecutor executor;
    @Inject
    @Named(value="macro")
    protected Transformation macroTransformation;
    @Inject
    protected CacheControl cacheControl;
    protected XDOM xdom;
    protected Syntax syntax;
    protected volatile XDOM preparedXDOM;
    protected volatile LocalDateTime preparedXDOMDate;

    @Override
    protected void initialize(BaseObject baseObject, Type roleType, String roleHint) throws WikiComponentException {
        super.initialize(baseObject, roleType, roleHint);
        XWikiDocument ownerDocument = baseObject.getOwnerDocument();
        this.syntax = ownerDocument.getSyntax();
        String content = baseObject.getStringValue(this.getContentPropertyName());
        this.xdom = this.parser.parse(content, this.syntax, (EntityReference)ownerDocument.getDocumentReference());
    }

    public XDOM getSourceContent() {
        return this.xdom;
    }

    public Syntax getSourceSyntax() {
        return this.syntax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XDOM getPreparedContent() {
        if (this.preparedXDOMDate == null || !this.cacheControl.isCacheReadAllowed((ChronoLocalDateTime)this.preparedXDOMDate)) {
            XDOM xDOM = this.xdom;
            synchronized (xDOM) {
                if (this.preparedXDOMDate == null || this.cacheControl.isCacheReadAllowed((ChronoLocalDateTime)this.preparedXDOMDate)) {
                    this.preparedXDOM = this.xdom.clone();
                    this.macroTransformation.prepare((Block)this.preparedXDOM);
                    this.preparedXDOMDate = LocalDateTime.now();
                }
            }
        }
        return this.preparedXDOM;
    }

    protected abstract String getContentPropertyName();
}

