/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.internal;

import javax.inject.Inject;
import org.xwiki.component.internal.multi.AbstractGenericComponentManager;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

public abstract class AbstractEntityComponentManager
extends AbstractGenericComponentManager
implements Initializable {
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private Execution execution;
    private final String contextKey = ((Object)((Object)this)).getClass().getName();

    protected abstract EntityReference getCurrentReference();

    protected ComponentManager getComponentManagerInternal() {
        EntityReference entityReference = this.getCurrentReference();
        if (entityReference == null) {
            return null;
        }
        ExecutionContext econtext = this.execution.getContext();
        if (econtext == null) {
            return super.getComponentManagerInternal();
        }
        EntityComponentManagerInstance contextComponentManager = (EntityComponentManagerInstance)econtext.getProperty(this.contextKey);
        if (contextComponentManager != null && contextComponentManager.entityReference.equals((Object)entityReference)) {
            return contextComponentManager.componentManager;
        }
        ComponentManager componentManager = super.getComponentManagerInternal();
        econtext.setProperty(this.contextKey, (Object)new EntityComponentManagerInstance(entityReference, componentManager));
        return componentManager;
    }

    protected String getKey() {
        EntityReference reference = this.getCurrentReference();
        return reference != null ? reference.getType().getLowerCase() + ":" + (String)this.serializer.serialize(reference, new Object[0]) : null;
    }

    protected void onComponentAdded() {
        EntityComponentManagerInstance contextComponentManager;
        ExecutionContext econtext = this.execution.getContext();
        if (econtext != null && (contextComponentManager = (EntityComponentManagerInstance)econtext.getProperty(this.contextKey)) != null && contextComponentManager.componentManager == null) {
            econtext.removeProperty(this.contextKey);
        }
    }

    private static class EntityComponentManagerInstance {
        protected final EntityReference entityReference;
        protected final ComponentManager componentManager;

        EntityComponentManagerInstance(EntityReference entityReference, ComponentManager componentManager) {
            this.entityReference = entityReference;
            this.componentManager = componentManager;
        }
    }
}

